/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.cli.AbstractStreamHandler;

class StreamFeeder
extends AbstractStreamHandler {
    private final AtomicReference<InputStream> input;
    private final AtomicReference<OutputStream> output;

    public StreamFeeder(InputStream input, OutputStream output) {
        this.input = new AtomicReference<InputStream>(input);
        this.output = new AtomicReference<OutputStream>(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.feed();
        }
        catch (Throwable throwable) {
            this.close();
            StreamFeeder streamFeeder = this;
            synchronized (streamFeeder) {
                this.notifyAll();
            }
        }
        finally {
            this.close();
            StreamFeeder streamFeeder = this;
            synchronized (streamFeeder) {
                this.notifyAll();
            }
        }
    }

    public void close() {
        OutputStream os;
        this.setDone();
        InputStream is = this.input.getAndSet(null);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if ((os = (OutputStream)this.output.getAndSet(null)) != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void feed() throws IOException {
        InputStream is = this.input.get();
        OutputStream os = this.output.get();
        if (is != null && os != null) {
            int data;
            while (!this.isDone() && (data = is.read()) != -1) {
                if (this.isDisabled()) continue;
                os.write(data);
            }
        }
    }
}

