/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestsToRun
implements Iterable<Class> {
    private final List<Class> locatedClasses;

    public TestsToRun(List<Class> locatedClasses) {
        this.locatedClasses = Collections.unmodifiableList(locatedClasses);
        HashSet<Class> testSets = new HashSet<Class>();
        for (Class testClass : locatedClasses) {
            if (testSets.contains(testClass)) {
                throw new RuntimeException("Duplicate test set '" + testClass.getName() + "'");
            }
            testSets.add(testClass);
        }
    }

    public static TestsToRun fromClass(Class clazz) throws TestSetFailedException {
        return new TestsToRun(Arrays.asList(clazz));
    }

    @Override
    public Iterator<Class> iterator() {
        return this.locatedClasses.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TestsToRun: [");
        for (Class clazz : this) {
            sb.append(" ").append(clazz.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean containsAtLeast(int atLeast) {
        return this.containsAtLeast(this.iterator(), atLeast);
    }

    private boolean containsAtLeast(Iterator it, int atLeast) {
        for (int i = 0; i < atLeast; ++i) {
            if (!it.hasNext()) {
                return false;
            }
            it.next();
        }
        return true;
    }

    public boolean containsExactly(int items) {
        Iterator<Class> it = this.iterator();
        return this.containsAtLeast(it, items) && !it.hasNext();
    }

    public boolean allowEagerReading() {
        return true;
    }

    public Class[] getLocatedClasses() {
        if (!this.allowEagerReading()) {
            throw new IllegalStateException("Cannot eagerly read");
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Iterator<Class> it = this.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class getClassByName(String className) {
        for (Class clazz : this) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        return null;
    }
}

