/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.MulticastingReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.SystemStreamCapturer;

public class ReporterManager {
    private final RunStatistics runStatisticsForThis;
    private final MulticastingReporter multicastingReporter;
    private final SystemStreamCapturer consoleCapturer = new SystemStreamCapturer();

    public ReporterManager(List reports, RunStatistics runStatisticsForThis) {
        this.multicastingReporter = new MulticastingReporter(reports);
        this.runStatisticsForThis = runStatisticsForThis;
    }

    public synchronized void writeMessage(String message) {
        this.multicastingReporter.writeMessage(message);
    }

    public synchronized void writeConsoleMessage(String message) {
        this.multicastingReporter.writeConsoleMessage(message);
    }

    public synchronized void runStarting() {
        this.multicastingReporter.runStarting();
    }

    public synchronized void runCompleted() {
        Iterator iterator;
        this.multicastingReporter.runCompleted();
        this.multicastingReporter.writeFooter("");
        this.multicastingReporter.writeFooter("Results :");
        this.multicastingReporter.writeFooter("");
        if (this.runStatisticsForThis.hadFailures()) {
            this.multicastingReporter.writeFooter("Failed tests: ");
            iterator = this.runStatisticsForThis.getFailureSources().iterator();
            while (iterator.hasNext()) {
                this.multicastingReporter.writeFooter("  " + iterator.next());
            }
            this.multicastingReporter.writeFooter("");
        }
        if (this.runStatisticsForThis.hadErrors()) {
            this.writeFooter("Tests in error: ");
            iterator = this.runStatisticsForThis.getErrorSources().iterator();
            while (iterator.hasNext()) {
                this.multicastingReporter.writeFooter("  " + iterator.next());
            }
            this.multicastingReporter.writeFooter("");
        }
        this.multicastingReporter.writeFooter(this.runStatisticsForThis.getSummary());
        this.multicastingReporter.writeFooter("");
        this.consoleCapturer.restoreStreams();
    }

    public synchronized void writeFooter(String footer) {
        this.multicastingReporter.writeFooter(footer);
    }

    public synchronized void testSetStarting(ReportEntry report) throws ReporterException {
        this.multicastingReporter.testSetStarting(report);
    }

    public synchronized void testSetCompleted(ReportEntry report) {
        this.multicastingReporter.testSetCompleted(report);
    }

    public synchronized void testStarting(ReportEntry report) {
        this.multicastingReporter.testStarting(report);
    }

    public synchronized void testSucceeded(ReportEntry report) {
        this.consoleCapturer.clearCapturedContent();
        this.runStatisticsForThis.incrementCompletedCount();
        this.multicastingReporter.testSucceeded(report);
    }

    public synchronized void testError(ReportEntry reportEntry) {
        this.testError(reportEntry, this.consoleCapturer.getStdOutLog(), this.consoleCapturer.getStdErrLog());
    }

    public synchronized void testError(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testError(reportEntry, stdOutLog, stdErrLog);
        this.runStatisticsForThis.incrementErrorsCount();
        this.runStatisticsForThis.incrementCompletedCount();
        this.runStatisticsForThis.addErrorSource(reportEntry.getName());
        this.consoleCapturer.clearCapturedContent();
    }

    public synchronized void testFailed(ReportEntry reportEntry) {
        this.testFailed(reportEntry, this.consoleCapturer.getStdOutLog(), this.consoleCapturer.getStdErrLog());
    }

    public synchronized void testFailed(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testFailed(reportEntry, stdOutLog, stdErrLog);
        this.runStatisticsForThis.incrementFailureCount();
        this.runStatisticsForThis.incrementCompletedCount();
        this.runStatisticsForThis.addFailureSource(reportEntry.getName());
        this.consoleCapturer.clearCapturedContent();
    }

    public synchronized void testSkipped(ReportEntry report) {
        this.consoleCapturer.clearCapturedContent();
        this.runStatisticsForThis.incrementSkippedCount();
        this.runStatisticsForThis.incrementCompletedCount();
        this.multicastingReporter.testSkipped(report);
    }

    public synchronized void reset() {
        this.multicastingReporter.reset();
    }
}

