/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.io.PrintWriter;
import java.io.Writer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkingWriterStreamConsumer
implements StreamConsumer {
    private PrintWriter printWriter;
    private int standardPrefixLength;
    private int headingPrefixLength;
    boolean showHeading;

    public ForkingWriterStreamConsumer(Writer writer, boolean showHeading) {
        this.showHeading = showHeading;
        this.printWriter = new PrintWriter(writer);
        this.standardPrefixLength = "@SL".length();
        this.headingPrefixLength = "@HL".length();
    }

    public void consumeLine(String line) {
        if (line.startsWith("@HL")) {
            if (this.showHeading) {
                this.printWriter.println(line.substring(this.headingPrefixLength));
                this.printWriter.flush();
            }
        } else if (line.startsWith("@SL")) {
            this.printWriter.println(line.substring(this.standardPrefixLength));
            this.printWriter.flush();
        } else {
            this.printWriter.println(line);
            this.printWriter.flush();
        }
    }
}

