/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.util.internal.ObjectUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

final class RunListenerAdapter
implements TestExecutionListener {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final ConcurrentMap<TestIdentifier, Long> testStartTime = new ConcurrentHashMap<TestIdentifier, Long>();
    private final ConcurrentMap<TestIdentifier, TestExecutionResult> failures = new ConcurrentHashMap<TestIdentifier, TestExecutionResult>();
    private final RunListener runListener;
    private volatile TestPlan testPlan;

    RunListenerAdapter(RunListener runListener) {
        this.runListener = runListener;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.failures.clear();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = null;
        this.testStartTime.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isContainer()) {
            if (testIdentifier.getSource().filter(ClassSource.class::isInstance).isPresent()) {
                this.testStartTime.put(testIdentifier, System.currentTimeMillis());
                this.runListener.testSetStarting((TestSetReportEntry)this.createReportEntry(testIdentifier));
                return;
            }
        }
        if (!testIdentifier.isTest()) return;
        this.testStartTime.put(testIdentifier, System.currentTimeMillis());
        this.runListener.testStarting((ReportEntry)this.createReportEntry(testIdentifier));
    }

    /*
     * Unable to fully structure code
     */
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!testIdentifier.isContainer()) ** GOTO lbl-1000
        if (testIdentifier.getSource().filter((Predicate<TestSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/junit/platform/engine/TestSource;)Z)(ClassSource.class)).isPresent()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isClass = v0;
        isTest = testIdentifier.isTest();
        if (isClass || isTest) {
            elapsed = this.computeElapsedTime(testIdentifier);
            switch (1.$SwitchMap$org$junit$platform$engine$TestExecutionResult$Status[testExecutionResult.getStatus().ordinal()]) {
                case 1: {
                    if (isTest) {
                        this.runListener.testAssumptionFailure((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, elapsed));
                        break;
                    }
                    this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, ObjectUtils.systemProps(), null, elapsed));
                    break;
                }
                case 2: {
                    if (!isTest) {
                        this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, ObjectUtils.systemProps(), null, elapsed));
                    } else if (testExecutionResult.getThrowable().filter((Predicate<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Throwable;)Z)(AssertionError.class)).isPresent()) {
                        this.runListener.testFailed((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, elapsed));
                    } else {
                        this.runListener.testError((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, elapsed));
                    }
                    this.failures.put(testIdentifier, testExecutionResult);
                    break;
                }
                default: {
                    if (isTest) {
                        this.runListener.testSucceeded((ReportEntry)this.createReportEntry(testIdentifier, null, elapsed));
                        break;
                    }
                    this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, null, ObjectUtils.systemProps(), null, elapsed));
                }
            }
        }
    }

    private Integer computeElapsedTime(TestIdentifier testIdentifier) {
        Long startTime = (Long)this.testStartTime.remove(testIdentifier);
        long endTime = System.currentTimeMillis();
        return startTime == null ? null : Integer.valueOf((int)(endTime - startTime));
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.testStartTime.remove(testIdentifier);
        this.runListener.testSkipped((ReportEntry)this.createReportEntry(testIdentifier, null, Collections.emptyMap(), reason, null));
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, Map<String, String> systemProperties, String reason, Integer elapsedTime) {
        String methodText;
        String classText;
        String[] classMethodName = this.toClassMethodName(testIdentifier);
        String className = classMethodName[0];
        if (Objects.equals(className, classText = classMethodName[1])) {
            classText = null;
        }
        String methodName = testIdentifier.isTest() ? classMethodName[2] : null;
        String string = methodText = testIdentifier.isTest() ? classMethodName[3] : null;
        if (Objects.equals(methodName, methodText)) {
            methodText = null;
        }
        StackTraceWriter stw = testExecutionResult == null ? null : this.toStackTraceWriter(className, methodName, testExecutionResult);
        return new SimpleReportEntry(className, classText, methodName, methodText, stw, elapsedTime, reason, systemProperties);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier) {
        return this.createReportEntry(testIdentifier, null, null);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, Integer elapsedTime) {
        return this.createReportEntry(testIdentifier, testExecutionResult, Collections.emptyMap(), null, elapsedTime);
    }

    private StackTraceWriter toStackTraceWriter(String realClassName, String realMethodName, TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case ABORTED: 
            case FAILED: {
                Throwable exception = testExecutionResult.getThrowable().orElse(null);
                return this.toStackTraceWriter(realClassName, realMethodName, exception);
            }
        }
        return testExecutionResult.getThrowable().map(t -> this.toStackTraceWriter(realClassName, realMethodName, (Throwable)t)).orElse(null);
    }

    private StackTraceWriter toStackTraceWriter(String realClassName, String realMethodName, Throwable throwable) {
        return new PojoStackTraceWriter(realClassName, realMethodName, throwable);
    }

    /*
     * Exception decompiling
     */
    private String[] toClassMethodName(TestIdentifier testIdentifier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Map<TestIdentifier, TestExecutionResult> getFailures() {
        return this.failures;
    }

    boolean hasFailingTests() {
        return !this.getFailures().isEmpty();
    }

    void reset() {
        this.getFailures().clear();
        this.testPlan = null;
    }

    private static /* synthetic */ String lambda$toClassMethodName$2(String s) {
        return s.substring(1 + s.lastIndexOf(46));
    }
}

