/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Properties;

class JUnitCoreParameters {
    private final String parallel;
    private final Boolean perCoreThreadCount;
    private final int threadCount;
    private final Boolean useUnlimitedThreads;
    public static final String PARALLEL_KEY = "parallel";
    public static final String PERCORETHREADCOUNT_KEY = "perCoreThreadCount";
    public static final String THREADCOUNT_KEY = "threadcount";
    public static final String USEUNLIMITEDTHREADS_KEY = "useUnlimitedThreads";

    public JUnitCoreParameters(Properties properties) {
        this.parallel = properties.getProperty(PARALLEL_KEY, "none").toLowerCase();
        this.perCoreThreadCount = Boolean.valueOf(properties.getProperty(PERCORETHREADCOUNT_KEY, "true"));
        this.threadCount = Integer.valueOf(properties.getProperty(THREADCOUNT_KEY, "2"));
        this.useUnlimitedThreads = Boolean.valueOf(properties.getProperty(USEUNLIMITEDTHREADS_KEY, "false"));
    }

    public boolean isParallelMethod() {
        return "methods".equals(this.parallel);
    }

    public boolean isParallelClasses() {
        return "classes".equals(this.parallel);
    }

    public boolean isParallelBoth() {
        return "both".equals(this.parallel);
    }

    public Boolean isPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public Boolean isUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public boolean isNoThreading() {
        return !this.isParallelClasses() && !this.isParallelMethod() && !this.isParallelBoth();
    }

    public boolean isAnyParallelitySelected() {
        return !this.isNoThreading();
    }

    public String toString() {
        return "parallel='" + this.parallel + '\'' + ", perCoreThreadCount=" + this.perCoreThreadCount + ", threadCount=" + this.threadCount + ", useUnlimitedThreads=" + this.useUnlimitedThreads;
    }
}

