/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.Arrays;
import org.apache.maven.surefire.api.report.CategorizedReportEntry;
import org.apache.maven.surefire.api.report.OutputReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.report.ClassMethodIndexer;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.RunModeSetter;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestNGReporter
implements TestOutputReceiver<OutputReportEntry>,
ITestListener,
ISuiteListener,
RunModeSetter {
    private final ClassMethodIndexer classMethodIndexer = new ClassMethodIndexer();
    private final TestReportListener<TestOutputReportEntry> reporter;
    private volatile RunMode runMode;

    public TestNGReporter(TestReportListener<TestOutputReportEntry> reportManager) {
        this.reporter = reportManager;
    }

    protected final RunListener getRunListener() {
        return this.reporter;
    }

    public void onTestStart(ITestResult result) {
        String className = result.getTestClass().getName();
        String methodName = TestNGReporter.testName(result);
        long testRunId = this.classMethodIndexer.indexClassMethod(className, methodName);
        String group = TestNGReporter.groupString(result.getMethod().getGroups(), className);
        this.reporter.testStarting((ReportEntry)new CategorizedReportEntry(this.runMode, Long.valueOf(testRunId), className, methodName, group));
    }

    public void onTestSuccess(ITestResult result) {
        String className = result.getTestClass().getName();
        String methodName = TestNGReporter.testName(result);
        long testRunId = this.classMethodIndexer.indexClassMethod(className, methodName);
        SimpleReportEntry report = new SimpleReportEntry(this.runMode, Long.valueOf(testRunId), className, null, methodName, null);
        this.reporter.testSucceeded((ReportEntry)report);
    }

    public void onTestFailure(ITestResult result) {
        IClass clazz = result.getTestClass();
        String className = clazz.getName();
        String methodName = TestNGReporter.testName(result);
        long testRunId = this.classMethodIndexer.indexClassMethod(className, methodName);
        PojoStackTraceWriter stackTraceWriter = new PojoStackTraceWriter(clazz.getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable());
        SimpleReportEntry report = SimpleReportEntry.withException((RunMode)this.runMode, (Long)testRunId, (String)clazz.getName(), null, (String)methodName, null, (StackTraceWriter)stackTraceWriter);
        this.reporter.testFailed((ReportEntry)report);
    }

    public void onTestSkipped(ITestResult result) {
        String className = result.getTestClass().getName();
        String methodName = TestNGReporter.testName(result);
        long testRunId = this.classMethodIndexer.indexClassMethod(className, methodName);
        Throwable t = result.getThrowable();
        String reason = t == null ? null : t.getMessage();
        SimpleReportEntry report = SimpleReportEntry.ignored((RunMode)this.runMode, (Long)testRunId, (String)className, null, (String)methodName, null, (String)reason);
        this.reporter.testSkipped((ReportEntry)report);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        IClass clazz = result.getTestClass();
        String className = clazz.getName();
        String methodName = TestNGReporter.testName(result);
        long testRunId = this.classMethodIndexer.indexClassMethod(className, methodName);
        PojoStackTraceWriter stackTraceWriter = new PojoStackTraceWriter(clazz.getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable());
        SimpleReportEntry report = SimpleReportEntry.withException((RunMode)this.runMode, (Long)testRunId, (String)className, null, (String)methodName, null, (StackTraceWriter)stackTraceWriter);
        this.reporter.testSucceeded((ReportEntry)report);
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
    }

    private static String groupString(String[] groups, String defaultValue) {
        String retVal;
        if (groups != null && groups.length > 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < groups.length; ++i) {
                str.append(groups[i]);
                if (i + 1 >= groups.length) continue;
                str.append(",");
            }
            retVal = str.toString();
        } else {
            retVal = defaultValue;
        }
        return retVal;
    }

    public void onConfigurationFailure(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        this.onTestSkipped(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
    }

    private static String testName(ITestResult result) {
        Object[] parameters = result.getParameters();
        String name = result.getName();
        return parameters == null || parameters.length == 0 ? name : name + Arrays.toString(parameters) + "(" + result.getMethod().getCurrentInvocationCount() + ")";
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public void writeTestOutput(OutputReportEntry reportEntry) {
        Long testRunId = this.classMethodIndexer.getLocalIndex();
        this.reporter.writeTestOutput((OutputReportEntry)new TestOutputReportEntry(reportEntry, this.runMode, testRunId));
    }
}

