/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.provider.AbstractProvider;
import org.apache.maven.surefire.api.provider.CommandChainReader;
import org.apache.maven.surefire.api.provider.CommandListener;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ConsoleOutputCapture;
import org.apache.maven.surefire.api.report.ReporterConfiguration;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestRequest;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.RunOrderCalculator;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.apache.maven.surefire.testng.TestNGDirectoryTestSuite;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testng.utils.FailFastEventsSingleton;

public class TestNGProvider
extends AbstractProvider {
    private final Map<String, String> providerProperties;
    private final ReporterConfiguration reporterConfiguration;
    private final ClassLoader testClassLoader;
    private final ScanResult scanResult;
    private final TestRequest testRequest;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final List<CommandLineOption> mainCliOptions;
    private final CommandChainReader commandsReader;

    public TestNGProvider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? bootParams.getCommandReader() : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        this.providerProperties = bootParams.getProviderProperties();
        this.testRequest = bootParams.getTestRequest();
        this.reporterConfiguration = bootParams.getReporterConfiguration();
        this.scanResult = bootParams.getScanResult();
        this.mainCliOptions = bootParams.getMainCliOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        if (this.isFailFast() && this.commandsReader != null) {
            this.registerPleaseStopListener();
        }
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        TestReportListener reporter = reporterFactory.createTestReportListener();
        try {
            if (this.isTestNGXmlTestSuite(this.testRequest)) {
                TestNGReporter testNGReporter = TestNGProvider.createTestNGReporter((TestReportListener<TestOutputReportEntry>)reporter);
                testNGReporter.setRunMode(RunMode.NORMAL_RUN);
                ConsoleOutputCapture.startCapture((TestOutputReceiver)testNGReporter);
                if (this.commandsReader != null) {
                    this.commandsReader.awaitStarted();
                }
                TestNGXmlTestSuite testNGXmlTestSuite = this.newXmlSuite();
                testNGXmlTestSuite.locateTestSets();
                testNGXmlTestSuite.execute(testNGReporter);
            } else {
                TestNGReporter testNGReporter = TestNGProvider.createTestNGReporter((TestReportListener<TestOutputReportEntry>)reporter);
                testNGReporter.setRunMode(RunMode.NORMAL_RUN);
                ConsoleOutputCapture.startCapture((TestOutputReceiver)testNGReporter);
                TestsToRun testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
                if (this.commandsReader != null) {
                    this.registerShutdownListener(testsToRun);
                    this.commandsReader.awaitStarted();
                }
                TestNGDirectoryTestSuite suite = this.newDirectorySuite();
                suite.execute(testsToRun, testNGReporter);
            }
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    boolean isTestNGXmlTestSuite(TestRequest testSuiteDefinition) {
        List suiteXmlFiles = testSuiteDefinition.getSuiteXmlFiles();
        return !suiteXmlFiles.isEmpty() && !this.hasSpecificTests();
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopListener() {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            public void update(Command command) {
                FailFastEventsSingleton.getInstance().setSkipOnNextTest();
            }
        });
    }

    private TestNGDirectoryTestSuite newDirectorySuite() {
        return new TestNGDirectoryTestSuite(this.testRequest.getTestSourceDirectory().toString(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.getTestFilter(), this.mainCliOptions, this.getSkipAfterFailureCount());
    }

    private TestNGXmlTestSuite newXmlSuite() {
        return new TestNGXmlTestSuite(this.testRequest.getSuiteXmlFiles(), this.testRequest.getTestSourceDirectory().toString(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.getSkipAfterFailureCount());
    }

    public Iterable<Class<?>> getSuites() {
        if (this.isTestNGXmlTestSuite(this.testRequest)) {
            try {
                return this.newXmlSuite().locateTestSets();
            }
            catch (TestSetFailedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.scanClassPath();
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(null, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    private boolean hasSpecificTests() {
        TestListResolver specificTestPatterns = this.testRequest.getTestListResolver();
        return !specificTestPatterns.isEmpty() && !specificTestPatterns.isWildcard();
    }

    private TestListResolver getTestFilter() {
        TestListResolver filter = TestListResolver.optionallyWildcardFilter((TestListResolver)this.testRequest.getTestListResolver());
        return filter.isWildcard() ? TestListResolver.getEmptyTestListResolver() : filter;
    }

    private static TestNGReporter createTestNGReporter(TestReportListener<TestOutputReportEntry> reportManager) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            Constructor<?> ctor = c.getConstructor(TestReportListener.class);
            return (TestNGReporter)ctor.newInstance(reportManager);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Bug in ConfigurationAwareTestNGReporter", e.getCause());
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
        catch (Exception e) {
            throw new RuntimeException("Bug in ConfigurationAwareTestNGReporter", e);
        }
    }
}

