/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.serialization;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.matcher.ClassNameMatcher;
import org.apache.mina.core.buffer.matcher.RegexpClassNameMatcher;
import org.apache.mina.core.buffer.matcher.WildcardClassNameMatcher;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class ObjectSerializationDecoder
extends CumulativeProtocolDecoder {
    private final ClassLoader classLoader;
    private int maxObjectSize = 0x100000;
    private final List<ClassNameMatcher> acceptMatchers = new ArrayList<ClassNameMatcher>();

    public ObjectSerializationDecoder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ObjectSerializationDecoder(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader");
        }
        this.classLoader = classLoader;
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (!in.prefixedDataAvailable(4, this.maxObjectSize)) {
            return false;
        }
        in.setMatchers(this.acceptMatchers);
        out.write(in.getObject(this.classLoader));
        return true;
    }

    public void accept(ClassNameMatcher classNameMatcher) {
        this.acceptMatchers.add(classNameMatcher);
    }

    public void accept(Pattern pattern) {
        this.acceptMatchers.add(new RegexpClassNameMatcher(pattern));
    }

    public void accept(String ... patterns) {
        for (String pattern : patterns) {
            this.acceptMatchers.add(new WildcardClassNameMatcher(pattern));
        }
    }
}

