/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.mc.test.core;

import java.io.IOException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.mc.test.core.AbstractMyFacesTestCase;
import org.apache.myfaces.mc.test.core.mock.MockMyFacesClient;
import org.apache.myfaces.mc.test.core.mock.ServletMockContainer;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpServletResponse;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockHttpSessionProxy;

public abstract class AbstractMyFacesRequestTestCase
extends AbstractMyFacesTestCase
implements ServletMockContainer {
    protected MockMyFacesClient client = null;
    protected MockHttpServletRequest request = null;
    protected boolean requestInitializedCalled = false;
    protected MockHttpServletResponse response = null;
    protected MockHttpSessionProxy session = null;
    protected MockHttpSession lastSession = null;
    protected Application application = null;
    protected ExternalContext externalContext = null;
    protected FacesContext facesContext = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.endRequest();
        this.session = null;
        this.lastSession = null;
        if (this.client != null) {
            this.client.setTestCase(null);
        }
        this.client = null;
        super.tearDown();
    }

    protected void setupRequest() {
        this.setupRequest(null);
    }

    protected void setupRequest(String pathInfo) {
        if (pathInfo == null) {
            this.setupRequest(null, null);
        } else {
            int queryIndex = pathInfo.indexOf("?");
            if (queryIndex >= 0) {
                this.setupRequest(pathInfo.substring(0, queryIndex), pathInfo.substring(queryIndex + 1));
            } else {
                this.setupRequest(pathInfo, null);
            }
        }
    }

    protected void setupRequest(String pathInfo, String query) {
        if (this.request != null) {
            this.endRequest();
        }
        this.request = this.lastSession == null ? new MockHttpServletRequest() : new MockHttpServletRequest((HttpSession)this.lastSession);
        this.request.setServletContext((ServletContext)this.servletContext);
        this.requestInitializedCalled = false;
        if (this.session == null) {
            this.session = new MockHttpSessionProxy(this.servletContext, this.request);
        } else {
            this.session.setRequest(this.request);
        }
        this.session.setServletContext((ServletContext)this.servletContext);
        this.response = new MockHttpServletResponse();
        this.request.setPathElements(this.getContextPath(), this.getServletPath(), pathInfo, query);
        this.facesContext = this.facesContextFactory.getFacesContext((Object)this.servletContext, (Object)this.request, (Object)this.response, this.lifecycle);
        this.externalContext = this.facesContext.getExternalContext();
        this.application = this.facesContext.getApplication();
        if (this.client != null) {
            this.client.apply(this.request);
            this.client.reset(this.facesContext);
        } else {
            this.client = this.createClient();
        }
    }

    protected MockMyFacesClient createClient() {
        return new MockMyFacesClient(this.facesContext, this);
    }

    @Override
    public final void startViewRequest(String viewId) {
        this.setupRequest(viewId);
        this.doRequestInitialized();
    }

    public final void startRequest() {
        this.startViewRequest(null);
        this.doRequestInitialized();
    }

    public void doRequestInitialized() {
        if (!this.requestInitializedCalled) {
            this.webContainer.requestInitialized(new ServletRequestEvent((ServletContext)this.servletContext, (ServletRequest)this.request));
            this.requestInitializedCalled = true;
        }
    }

    @Override
    public final void endRequest() {
        this.doRequestDestroyed();
        this.tearDownRequest();
    }

    public void doRequestDestroyed() {
        if (this.request != null) {
            this.lastSession = (MockHttpSession)this.request.getSession(false);
            this.webContainer.requestDestroyed(new ServletRequestEvent((ServletContext)this.servletContext, (ServletRequest)this.request));
        }
    }

    protected void tearDownRequest() {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        this.facesContext = null;
        this.externalContext = null;
        this.application = null;
        this.response = null;
        this.request = null;
    }

    protected String getContextPath() {
        return "/test";
    }

    protected String getServletPath() {
        return "/faces";
    }

    public void processLifecycleExecute() {
        this.processLifecycleExecute(this.facesContext);
    }

    public void processLifecycleRender() {
        this.processLifecycleRender(this.facesContext);
    }

    public void processLifecycleExecuteAndRender() {
        this.processLifecycleExecute();
        this.renderResponse();
    }

    public void restoreView() {
        this.restoreView(this.facesContext);
    }

    public void applyRequestValues() {
        this.applyRequestValues(this.facesContext);
    }

    public void processValidations() {
        this.processValidations(this.facesContext);
    }

    public void updateModelValues() {
        this.updateModelValues(this.facesContext);
    }

    public void invokeApplication() {
        this.invokeApplication(this.facesContext);
    }

    public void renderResponse() {
        this.renderResponse(this.facesContext);
    }

    public void processRemainingExecutePhases() {
        this.processRemainingExecutePhases(this.facesContext);
    }

    @Override
    public void processRemainingPhases() {
        this.processRemainingPhases(this.facesContext);
    }

    public void executeBeforeRender() {
        this.executeBeforeRender(this.facesContext);
    }

    public void executeViewHandlerRender() {
        this.executeViewHandlerRender(this.facesContext);
    }

    public void executeBuildViewCycle() {
        this.executeBuildViewCycle(this.facesContext);
    }

    public void executeAfterRender() {
        this.executeAfterRender(this.facesContext);
    }

    public String getRenderedContent() throws IOException {
        return this.getRenderedContent(this.facesContext);
    }

    @Override
    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public MockHttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public FacesContext getFacesContext() {
        return this.facesContext;
    }
}

