/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.mc.test.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.Flash;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.view.ViewDeclarationLanguage;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.config.DefaultFacesConfigurationProvider;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.impl.digester.elements.FacesConfigImpl;
import org.apache.myfaces.config.impl.digester.elements.FactoryImpl;
import org.apache.myfaces.config.impl.digester.elements.ManagedBeanImpl;
import org.apache.myfaces.lifecycle.LifecycleImpl;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.mc.test.core.annotation.DeclareFacesConfig;
import org.apache.myfaces.mc.test.core.annotation.ManagedBeans;
import org.apache.myfaces.mc.test.core.annotation.PageBean;
import org.apache.myfaces.mc.test.core.annotation.TestConfig;
import org.apache.myfaces.mc.test.core.mock.DefaultContext;
import org.apache.myfaces.mc.test.core.mock.MockInitialContextFactory;
import org.apache.myfaces.mc.test.core.mock.MockMyFacesViewDeclarationLanguageFactory;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.impl.DefaultFacesConfigurationProviderFactory;
import org.apache.myfaces.spi.impl.NoInjectionAnnotationInjectionProvider;
import org.apache.myfaces.test.el.MockExpressionFactory;
import org.apache.myfaces.test.mock.MockPrintWriter;
import org.apache.myfaces.test.mock.MockServletConfig;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.MockWebContainer;
import org.apache.myfaces.webapp.AbstractFacesInitializer;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.StartupServletContextListener;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.xml.sax.SAXException;

public abstract class AbstractMyFacesTestCase {
    private static final Class<?> PHASE_EXECUTOR_CLASS;
    private static final Class<?> PHASE_MANAGER_CLASS;
    public static final String PHASE_MANAGER_INSTANCE = "org.apache.myfaces.test.PHASE_MANAGER_INSTANCE";
    public static final String LAST_PHASE_PROCESSED = "oam.LAST_PHASE_PROCESSED";
    public static final String LAST_RENDER_PHASE_STEP = "oam.LAST_RENDER_PHASE_STEP";
    public static final int BEFORE_RENDER_STEP = 1;
    public static final int BUILD_VIEW_CYCLE_STEP = 2;
    public static final int VIEWHANDLER_RENDER_STEP = 3;
    public static final int AFTER_RENDER_STEP = 4;
    private ClassLoader threadContextClassLoader = null;
    private boolean classLoaderSet = false;
    private Context jndiContext = null;
    protected MockServletConfig servletConfig = null;
    protected MockServletContext servletContext = null;
    protected MockWebContainer webContainer = null;
    protected StartupServletContextListener listener = null;
    protected FacesConfigurationProvider facesConfigurationProvider = null;
    protected FacesContextFactory facesContextFactory = null;
    protected LifecycleFactory lifecycleFactory = null;
    protected Lifecycle lifecycle;
    private static FacesConfig standardFacesConfig;
    private static Map<String, SharedFacesConfiguration> sharedConfiguration;
    private SharedFacesConfiguration jsfConfiguration;

    @Before
    public void setUp() throws Exception {
        TestConfig testConfig;
        boolean enableJNDI;
        this.setUpClassloader();
        this.jsfConfiguration = sharedConfiguration.get(this.getTestJavaClass().getName());
        if (this.jsfConfiguration == null) {
            this.jsfConfiguration = new SharedFacesConfiguration();
        }
        boolean bl = enableJNDI = (testConfig = this.getTestJavaClass().getAnnotation(TestConfig.class)) != null ? testConfig.enableJNDI() : true;
        if (enableJNDI) {
            System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
            this.jndiContext = new DefaultContext();
            MockInitialContextFactory.setCurrentContext(this.jndiContext);
        }
        this.setUpServletObjects();
        FactoryFinder.releaseFactories();
        this.setUpServletListeners();
        this.webContainer.contextInitialized(new ServletContextEvent((ServletContext)this.servletContext));
        this.setUpFacesServlet();
        sharedConfiguration.put(this.getTestJavaClass().getName(), this.jsfConfiguration);
    }

    protected void setUpClassloader() throws Exception {
        this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], this.getClass().getClassLoader()));
        this.classLoaderSet = true;
    }

    protected void setUpServletObjects() throws Exception {
        this.servletContext = new MockServletContext();
        this.servletConfig = new MockServletConfig((ServletContext)this.servletContext);
        this.servletContext.setDocumentRoot(this.getWebappContextURI());
        this.webContainer = new MockWebContainer();
        this.servletContext.setWebContainer(this.webContainer);
        this.setUpWebConfigParams();
    }

    protected void setUpWebConfigParams() throws Exception {
        this.servletContext.addInitParameter("org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE", "true");
        this.servletContext.addInitParameter("javax.faces.PROJECT_STAGE", "UnitTest");
        this.servletContext.addInitParameter("javax.faces.PARTIAL_STATE_SAVING", "true");
        this.servletContext.addInitParameter("javax.faces.FACELETS_REFRESH_PERIOD", "-1");
        this.servletContext.addInitParameter("org.apache.myfaces.spi.InjectionProvider", NoInjectionAnnotationInjectionProvider.class.getName());
        this.servletContext.addInitParameter("org.apache.myfaces.config.annotation.LifecycleProvider", NoInjectionAnnotationLifecycleProvider.class.getName());
    }

    protected URI getWebappContextURI() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = cl.getResource(this.getWebappResourcePath());
            if (url == null) {
                throw new FileNotFoundException(cl.getResource("").getFile() + this.getWebappResourcePath() + " was not found");
            }
            return new URI(url.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Error Initializing Context", e);
        }
    }

    protected String getWebappResourcePath() {
        TestConfig testConfig = this.getTestJavaClass().getAnnotation(TestConfig.class);
        if (testConfig != null && testConfig.webappResourcePath() != null && !"testClassResourcePackage".equals(testConfig.webappResourcePath())) {
            return testConfig.webappResourcePath();
        }
        return this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf(46)).replace('.', '/') + "/";
    }

    protected ExpressionFactory createExpressionFactory() {
        TestConfig testConfig = this.getTestJavaClass().getAnnotation(TestConfig.class);
        if (testConfig != null && testConfig.expressionFactory() != null && testConfig.expressionFactory().length() > 0) {
            return (ExpressionFactory)ClassUtils.newInstance((String)testConfig.expressionFactory(), ExpressionFactory.class);
        }
        return new MockExpressionFactory();
    }

    protected void setUpServlets() throws Exception {
        this.setUpFacesServlet();
    }

    protected void setUpServletListeners() throws Exception {
        this.setUpMyFaces();
    }

    protected FacesConfigurationProvider createFacesConfigurationProvider() {
        return new MyFacesMockFacesConfigurationProvider(this);
    }

    protected AbstractFacesInitializer createFacesInitializer() {
        return new JUnitFacesInitializer(this);
    }

    protected void setUpMyFaces() throws Exception {
        if (this.facesConfigurationProvider == null) {
            this.facesConfigurationProvider = this.createFacesConfigurationProvider();
        }
        this.servletContext.setAttribute(DefaultFacesConfigurationProviderFactory.FACES_CONFIGURATION_PROVIDER_INSTANCE_KEY, (Object)this.facesConfigurationProvider);
        this.listener = new StartupServletContextListener();
        this.listener.setFacesInitializer((FacesInitializer)this.createFacesInitializer());
        this.webContainer.subscribeListener((Object)this.listener);
    }

    protected void tearDownMyFaces() {
    }

    protected void setUpFacesServlet() throws Exception {
        this.lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        this.lifecycle = this.lifecycleFactory.getLifecycle(this.getLifecycleId());
    }

    protected void tearDownFacesServlet() throws Exception {
        this.lifecycleFactory = null;
        this.facesContextFactory = null;
    }

    protected void tearDownServlets() throws Exception {
        this.tearDownFacesServlet();
    }

    protected void tearDownServletListeners() throws Exception {
        this.tearDownMyFaces();
    }

    @After
    public void tearDown() throws Exception {
        this.tearDownServlets();
        this.webContainer.contextDestroyed(new ServletContextEvent((ServletContext)this.servletContext));
        this.tearDownServletListeners();
        this.listener = null;
        this.servletConfig = null;
        this.servletContext = null;
        FactoryFinder.releaseFactories();
        if (this.jndiContext != null) {
            MockInitialContextFactory.clearCurrentContext();
        }
        this.tearDownClassloader();
    }

    protected void tearDownClassloader() throws Exception {
        if (this.classLoaderSet) {
            Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
            this.threadContextClassLoader = null;
            this.classLoaderSet = false;
        }
    }

    @AfterClass
    public static void tearDownClass() {
        standardFacesConfig = null;
        sharedConfiguration.clear();
    }

    private String getLifecycleId() {
        String serLifecycleId = this.servletConfig.getInitParameter("javax.faces.LIFECYCLE_ID");
        String appLifecycleId = this.servletConfig.getServletContext().getInitParameter("javax.faces.LIFECYCLE_ID");
        appLifecycleId = serLifecycleId == null ? appLifecycleId : serLifecycleId;
        return appLifecycleId != null ? appLifecycleId : "DEFAULT";
    }

    public void processLifecycleExecute(FacesContext facesContext) {
        this.lifecycle.attachWindow(facesContext);
        this.lifecycle.execute(facesContext);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.INVOKE_APPLICATION);
    }

    public void restoreView(FacesContext facesContext) {
        this.lifecycle.attachWindow(facesContext);
        this.executePhase(facesContext, PhaseId.RESTORE_VIEW);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.RESTORE_VIEW);
    }

    public void applyRequestValues(FacesContext facesContext) {
        if (facesContext.getRenderResponse() || facesContext.getResponseComplete()) {
            return;
        }
        this.processRemainingPhasesBefore(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        this.executePhase(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void processValidations(FacesContext facesContext) {
        if (facesContext.getRenderResponse() || facesContext.getResponseComplete()) {
            return;
        }
        this.processRemainingPhasesBefore(facesContext, PhaseId.PROCESS_VALIDATIONS);
        this.executePhase(facesContext, PhaseId.PROCESS_VALIDATIONS);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.PROCESS_VALIDATIONS);
    }

    public void updateModelValues(FacesContext facesContext) {
        if (facesContext.getRenderResponse() || facesContext.getResponseComplete()) {
            return;
        }
        this.processRemainingPhasesBefore(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        this.executePhase(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void invokeApplication(FacesContext facesContext) {
        if (facesContext.getRenderResponse() || facesContext.getResponseComplete()) {
            return;
        }
        this.processRemainingPhasesBefore(facesContext, PhaseId.INVOKE_APPLICATION);
        this.executePhase(facesContext, PhaseId.INVOKE_APPLICATION);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.INVOKE_APPLICATION);
    }

    public void processLifecycleRender(FacesContext facesContext) {
        this.renderResponse(facesContext);
    }

    public void renderResponse(FacesContext facesContext) {
        this.processRemainingExecutePhases(facesContext);
        this.lifecycle.render(facesContext);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.RENDER_RESPONSE);
        facesContext.getAttributes().put(LAST_RENDER_PHASE_STEP, 4);
    }

    protected void processRemainingPhasesBefore(FacesContext facesContext, PhaseId phaseId) {
        PhaseId lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
        if (lastPhaseId == null) {
            if (!phaseId.equals(PhaseId.RESTORE_VIEW)) {
                this.restoreView(facesContext);
                lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
            } else {
                return;
            }
        }
        if (PhaseId.APPLY_REQUEST_VALUES.equals(phaseId)) {
            return;
        }
        boolean continueProcess = false;
        if (continueProcess || PhaseId.RESTORE_VIEW.equals(lastPhaseId)) {
            this.applyRequestValues(facesContext);
            lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
            continueProcess = true;
        }
        if (PhaseId.PROCESS_VALIDATIONS.equals(phaseId)) {
            return;
        }
        if (continueProcess || PhaseId.APPLY_REQUEST_VALUES.equals(lastPhaseId)) {
            this.processValidations(facesContext);
            lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
            continueProcess = true;
        }
        if (PhaseId.UPDATE_MODEL_VALUES.equals(phaseId)) {
            return;
        }
        if (continueProcess || PhaseId.PROCESS_VALIDATIONS.equals(lastPhaseId)) {
            this.updateModelValues(facesContext);
            lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
            continueProcess = true;
        }
        if (PhaseId.INVOKE_APPLICATION.equals(phaseId)) {
            return;
        }
        if (continueProcess || PhaseId.UPDATE_MODEL_VALUES.equals(lastPhaseId)) {
            this.invokeApplication(facesContext);
            lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
            continueProcess = true;
        }
        if (PhaseId.RENDER_RESPONSE.equals(phaseId)) {
            return;
        }
        if (continueProcess || PhaseId.INVOKE_APPLICATION.equals(lastPhaseId)) {
            this.renderResponse(facesContext);
            lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
            continueProcess = true;
        }
    }

    public void processRemainingExecutePhases(FacesContext facesContext) {
        PhaseId lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
        if (lastPhaseId == null) {
            this.processLifecycleExecute(facesContext);
            return;
        }
        boolean continueProcess = false;
        if (PhaseId.RESTORE_VIEW.equals(lastPhaseId)) {
            this.applyRequestValues(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.APPLY_REQUEST_VALUES.equals(lastPhaseId)) {
            this.processValidations(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.PROCESS_VALIDATIONS.equals(lastPhaseId)) {
            this.updateModelValues(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.UPDATE_MODEL_VALUES.equals(lastPhaseId)) {
            this.invokeApplication(facesContext);
            boolean bl = true;
        }
    }

    public void processRemainingPhases(FacesContext facesContext) {
        PhaseId lastPhaseId = (PhaseId)facesContext.getAttributes().get(LAST_PHASE_PROCESSED);
        if (lastPhaseId == null) {
            this.processLifecycleExecute(facesContext);
            this.renderResponse(facesContext);
            return;
        }
        boolean continueProcess = false;
        if (PhaseId.RESTORE_VIEW.equals(lastPhaseId)) {
            this.applyRequestValues(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.APPLY_REQUEST_VALUES.equals(lastPhaseId)) {
            this.processValidations(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.PROCESS_VALIDATIONS.equals(lastPhaseId)) {
            this.updateModelValues(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.UPDATE_MODEL_VALUES.equals(lastPhaseId)) {
            this.invokeApplication(facesContext);
            continueProcess = true;
        }
        if (continueProcess || PhaseId.INVOKE_APPLICATION.equals(lastPhaseId)) {
            Integer step = (Integer)facesContext.getAttributes().get(LAST_RENDER_PHASE_STEP);
            if (step == null) {
                this.renderResponse(facesContext);
            } else if (1 == step) {
                this.executeBuildViewCycle(facesContext);
                this.executeViewHandlerRender(facesContext);
                this.executeAfterRender(facesContext);
            } else if (2 == step) {
                this.executeViewHandlerRender(facesContext);
                this.executeAfterRender(facesContext);
            } else if (3 == step) {
                this.executeAfterRender(facesContext);
            }
        }
    }

    protected boolean isScanAnnotations() {
        TestConfig testConfig = this.getTestJavaClass().getAnnotation(TestConfig.class);
        if (testConfig != null) {
            return testConfig.scanAnnotations();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeBeforeRender(FacesContext facesContext) {
        if (!(this.lifecycle instanceof LifecycleImpl)) throw new UnsupportedOperationException("Cannot execute phase on custom lifecycle instances");
        LifecycleImpl lifecycleImpl = (LifecycleImpl)this.lifecycle;
        Object phaseExecutor = null;
        Object phaseManager = null;
        try {
            Field renderExecutorField = lifecycleImpl.getClass().getDeclaredField("renderExecutor");
            if (!renderExecutorField.isAccessible()) {
                renderExecutorField.setAccessible(true);
            }
            phaseExecutor = renderExecutorField.get(lifecycleImpl);
            if (facesContext.getResponseComplete()) {
                return;
            }
            phaseManager = facesContext.getAttributes().get(PHASE_MANAGER_INSTANCE);
            if (phaseManager == null) {
                Constructor<?> plmc;
                Method getPhaseListenersMethod = lifecycleImpl.getClass().getDeclaredMethod("getPhaseListeners", new Class[0]);
                if (!getPhaseListenersMethod.isAccessible()) {
                    getPhaseListenersMethod.setAccessible(true);
                }
                if (!(plmc = PHASE_MANAGER_CLASS.getDeclaredConstructor(Lifecycle.class, FacesContext.class, PhaseListener[].class)).isAccessible()) {
                    plmc.setAccessible(true);
                }
                phaseManager = plmc.newInstance(this.lifecycle, facesContext, getPhaseListenersMethod.invoke((Object)lifecycleImpl, null));
                facesContext.getAttributes().put(PHASE_MANAGER_INSTANCE, phaseManager);
            }
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException("Cannot get executors from LifecycleImpl", ex);
        }
        catch (SecurityException ex) {
            throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
        }
        catch (InvocationTargetException ex) {
            throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
        }
        catch (InstantiationException ex) {
            throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
        }
        Flash flash = facesContext.getExternalContext().getFlash();
        try {
            facesContext.setCurrentPhaseId(PhaseId.RENDER_RESPONSE);
            flash.doPrePhaseActions(facesContext);
            Method doPrePhaseActionsMethod = phaseExecutor.getClass().getMethod("doPrePhaseActions", FacesContext.class);
            if (!doPrePhaseActionsMethod.isAccessible()) {
                doPrePhaseActionsMethod.setAccessible(true);
            }
            doPrePhaseActionsMethod.invoke(phaseExecutor, facesContext);
            Method informPhaseListenersBeforeMethod = phaseManager.getClass().getDeclaredMethod("informPhaseListenersBefore", PhaseId.class);
            if (!informPhaseListenersBeforeMethod.isAccessible()) {
                informPhaseListenersBeforeMethod.setAccessible(true);
            }
            informPhaseListenersBeforeMethod.invoke(phaseManager, PhaseId.RENDER_RESPONSE);
            if (facesContext.getResponseComplete()) {
                return;
            }
        }
        catch (Throwable e) {
            ExceptionQueuedEventContext context = new ExceptionQueuedEventContext(facesContext, e, null, PhaseId.RENDER_RESPONSE);
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)context);
        }
        facesContext.getExceptionHandler().handle();
        facesContext.getAttributes().remove(PHASE_MANAGER_INSTANCE);
        facesContext.getAttributes().put(LAST_RENDER_PHASE_STEP, 1);
    }

    public void executeBuildViewCycle(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        int loops = 0;
        int maxLoops = 15;
        if (facesContext.getViewRoot() == null) {
            throw new ViewNotFoundException("A view is required to execute " + facesContext.getCurrentPhaseId());
        }
        try {
            boolean isNotSameRoot;
            String viewId;
            String newViewId;
            do {
                UIViewRoot root;
                UIViewRoot previousRoot = root = facesContext.getViewRoot();
                viewId = root.getViewId();
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, viewId);
                if (vdl != null) {
                    vdl.buildView(facesContext, root);
                }
                application.publishEvent(facesContext, PreRenderViewEvent.class, (Object)root);
                if (facesContext.getResponseComplete()) {
                    return;
                }
                root = facesContext.getViewRoot();
                newViewId = root.getViewId();
                boolean bl = isNotSameRoot = !(newViewId == null ? newViewId == viewId : newViewId.equals(viewId)) || !previousRoot.equals(root);
            } while (newViewId == null && viewId != null || newViewId != null && (!newViewId.equals(viewId) || isNotSameRoot) && ++loops < maxLoops);
            if (loops == maxLoops) {
                boolean vdl = facesContext.isProjectStage(ProjectStage.Production);
            }
            facesContext.getAttributes().put(LAST_RENDER_PHASE_STEP, 2);
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void executeViewHandlerRender(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        try {
            viewHandler.renderView(facesContext, facesContext.getViewRoot());
            List messageList = facesContext.getMessageList();
            if (!messageList.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                int size = messageList.size();
                for (int i = 0; i < size; ++i) {
                    FacesMessage message = (FacesMessage)messageList.get(i);
                    if (message.isRendered()) continue;
                    builder.append("\n- ");
                    builder.append(message.getDetail());
                }
            }
            facesContext.getAttributes().put(LAST_RENDER_PHASE_STEP, 3);
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void executeAfterRender(FacesContext facesContext) {
        if (this.lifecycle instanceof LifecycleImpl) {
            LifecycleImpl lifecycleImpl = (LifecycleImpl)this.lifecycle;
            Object phaseExecutor = null;
            Object phaseManager = null;
            Method informPhaseListenersAfterMethod = null;
            try {
                Field renderExecutorField = lifecycleImpl.getClass().getDeclaredField("renderExecutor");
                if (!renderExecutorField.isAccessible()) {
                    renderExecutorField.setAccessible(true);
                }
                phaseExecutor = renderExecutorField.get(lifecycleImpl);
                phaseManager = facesContext.getAttributes().get(PHASE_MANAGER_INSTANCE);
                if (phaseManager == null) {
                    Constructor<?> plmc;
                    Method getPhaseListenersMethod = lifecycleImpl.getClass().getDeclaredMethod("getPhaseListeners", new Class[0]);
                    if (!getPhaseListenersMethod.isAccessible()) {
                        getPhaseListenersMethod.setAccessible(true);
                    }
                    if (!(plmc = PHASE_MANAGER_CLASS.getDeclaredConstructor(Lifecycle.class, FacesContext.class, PhaseListener[].class)).isAccessible()) {
                        plmc.setAccessible(true);
                    }
                    phaseManager = plmc.newInstance(this.lifecycle, facesContext, getPhaseListenersMethod.invoke((Object)lifecycleImpl, null));
                    facesContext.getAttributes().put(PHASE_MANAGER_INSTANCE, phaseManager);
                }
                if (!(informPhaseListenersAfterMethod = phaseManager.getClass().getDeclaredMethod("informPhaseListenersAfter", PhaseId.class)).isAccessible()) {
                    informPhaseListenersAfterMethod.setAccessible(true);
                }
                informPhaseListenersAfterMethod.invoke(phaseManager, PhaseId.RENDER_RESPONSE);
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (SecurityException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (InstantiationException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
        } else {
            throw new UnsupportedOperationException("Cannot execute phase on custom lifecycle instances");
        }
        Flash flash = facesContext.getExternalContext().getFlash();
        flash.doPostPhaseActions(facesContext);
        facesContext.getExceptionHandler().handle();
        facesContext.getAttributes().remove(PHASE_MANAGER_INSTANCE);
        facesContext.getAttributes().put(LAST_RENDER_PHASE_STEP, 4);
        facesContext.getAttributes().put(LAST_PHASE_PROCESSED, PhaseId.RENDER_RESPONSE);
    }

    protected void executePhase(FacesContext facesContext, PhaseId phase) {
        if (this.lifecycle instanceof LifecycleImpl) {
            LifecycleImpl lifecycleImpl = (LifecycleImpl)this.lifecycle;
            int phaseId = phase.equals(PhaseId.RESTORE_VIEW) ? 0 : (phase.equals(PhaseId.APPLY_REQUEST_VALUES) ? 1 : (phase.equals(PhaseId.PROCESS_VALIDATIONS) ? 2 : (phase.equals(PhaseId.UPDATE_MODEL_VALUES) ? 3 : (phase.equals(PhaseId.INVOKE_APPLICATION) ? 4 : 5))));
            Method executePhaseMethod = null;
            Object phaseManager = null;
            Object phaseExecutor = null;
            try {
                if (phaseId < 5) {
                    Field lifecycleExecutorsField = lifecycleImpl.getClass().getDeclaredField("lifecycleExecutors");
                    if (!lifecycleExecutorsField.isAccessible()) {
                        lifecycleExecutorsField.setAccessible(true);
                    }
                    phaseExecutor = ((Object[])lifecycleExecutorsField.get(lifecycleImpl))[phaseId];
                } else {
                    Field renderExecutorField = lifecycleImpl.getClass().getDeclaredField("renderExecutor");
                    if (!renderExecutorField.isAccessible()) {
                        renderExecutorField.setAccessible(true);
                    }
                    phaseExecutor = renderExecutorField.get(lifecycleImpl);
                }
                phaseManager = facesContext.getAttributes().get(PHASE_MANAGER_INSTANCE);
                if (phaseManager == null) {
                    Constructor<?> plmc;
                    Method getPhaseListenersMethod = lifecycleImpl.getClass().getDeclaredMethod("getPhaseListeners", new Class[0]);
                    if (!getPhaseListenersMethod.isAccessible()) {
                        getPhaseListenersMethod.setAccessible(true);
                    }
                    if (!(plmc = PHASE_MANAGER_CLASS.getDeclaredConstructor(Lifecycle.class, FacesContext.class, PhaseListener[].class)).isAccessible()) {
                        plmc.setAccessible(true);
                    }
                    phaseManager = plmc.newInstance(this.lifecycle, facesContext, getPhaseListenersMethod.invoke((Object)lifecycleImpl, null));
                    facesContext.getAttributes().put(PHASE_MANAGER_INSTANCE, phaseManager);
                }
                if (!(executePhaseMethod = lifecycleImpl.getClass().getDeclaredMethod("executePhase", FacesContext.class, PHASE_EXECUTOR_CLASS, PHASE_MANAGER_CLASS)).isAccessible()) {
                    executePhaseMethod.setAccessible(true);
                }
                executePhaseMethod.invoke((Object)lifecycleImpl, facesContext, phaseExecutor, phaseManager);
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (SecurityException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            catch (InstantiationException ex) {
                throw new UnsupportedOperationException("Cannot get executors from LifecycleImpl", ex);
            }
            if (phase.equals(PhaseId.RENDER_RESPONSE)) {
                facesContext.getAttributes().remove(PHASE_MANAGER_INSTANCE);
            }
        } else {
            throw new UnsupportedOperationException("Cannot execute phase on custom lifecycle instances");
        }
    }

    protected String getRenderedContent(FacesContext facesContext) throws IOException {
        MockPrintWriter writer1 = (MockPrintWriter)((HttpServletResponse)facesContext.getExternalContext().getResponse()).getWriter();
        return String.valueOf(writer1.content());
    }

    protected Class<?> getTestJavaClass() {
        return this.getClass();
    }

    private void validateFacesConfig(ExternalContext ectx, URL url) throws IOException, SAXException {
        String version = ConfigFilesXmlValidationUtils.getFacesConfigVersion((URL)url);
        if ("1.2".equals(version) || "2.0".equals(version) || "2.1".equals(version)) {
            ConfigFilesXmlValidationUtils.validateFacesConfigFile((URL)url, (ExternalContext)ectx, (String)version);
        }
    }

    static {
        Class<?> phaseExecutorClass = null;
        Class<?> phaseManagerClass = null;
        try {
            phaseExecutorClass = Class.forName("org.apache.myfaces.lifecycle.PhaseExecutor");
            phaseManagerClass = Class.forName("org.apache.myfaces.lifecycle.PhaseListenerManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        PHASE_EXECUTOR_CLASS = phaseExecutorClass;
        PHASE_MANAGER_CLASS = phaseManagerClass;
        sharedConfiguration = new ConcurrentHashMap<String, SharedFacesConfiguration>();
    }

    protected static class SharedFacesConfiguration {
        private List<FacesConfig> classloaderFacesConfig;
        private FacesConfig annotationFacesConfig;
        private List<FacesConfig> faceletTaglibFacesConfig;
        private List<FacesConfig> facesFlowFacesConfig;
        private FacesConfig metaInfServicesFacesConfig;
        private List<FacesConfig> contextSpecifiedFacesConfig;

        protected SharedFacesConfiguration() {
        }

        public FacesConfig getAnnotationsFacesConfig() {
            return this.annotationFacesConfig;
        }

        public void setAnnotationFacesConfig(FacesConfig annotationFacesConfig) {
            this.annotationFacesConfig = annotationFacesConfig;
        }

        public FacesConfig getAnnotationFacesConfig() {
            return this.annotationFacesConfig;
        }

        public List<FacesConfig> getFaceletTaglibFacesConfig() {
            return this.faceletTaglibFacesConfig;
        }

        public void setFaceletTaglibFacesConfig(List<FacesConfig> faceletTaglibFacesConfig) {
            this.faceletTaglibFacesConfig = faceletTaglibFacesConfig;
        }

        public List<FacesConfig> getFacesFlowFacesConfig() {
            return this.facesFlowFacesConfig;
        }

        public void setFacesFlowFacesConfig(List<FacesConfig> facesFlowFacesConfig) {
            this.facesFlowFacesConfig = facesFlowFacesConfig;
        }

        public FacesConfig getMetaInfServicesFacesConfig() {
            return this.metaInfServicesFacesConfig;
        }

        public void setMetaInfServicesFacesConfig(FacesConfig metaInfServicesFacesConfig) {
            this.metaInfServicesFacesConfig = metaInfServicesFacesConfig;
        }

        public List<FacesConfig> getContextSpecifiedFacesConfig() {
            return this.contextSpecifiedFacesConfig;
        }

        public void setContextSpecifiedFacesConfig(List<FacesConfig> contextSpecifiedFacesConfig) {
            this.contextSpecifiedFacesConfig = contextSpecifiedFacesConfig;
        }

        public List<FacesConfig> getClassloaderFacesConfig() {
            return this.classloaderFacesConfig;
        }

        public void setClassloaderFacesConfig(List<FacesConfig> classloaderFacesConfigList) {
            this.classloaderFacesConfig = classloaderFacesConfigList;
        }
    }

    protected class JUnitFacesInitializer
    extends AbstractFacesInitializer {
        private final AbstractMyFacesTestCase testCase;

        public JUnitFacesInitializer(AbstractMyFacesTestCase testCase) {
            this.testCase = testCase;
        }

        protected void initContainerIntegration(ServletContext servletContext, ExternalContext externalContext) {
            ExpressionFactory expressionFactory = AbstractMyFacesTestCase.this.createExpressionFactory();
            RuntimeConfig runtimeConfig = this.buildConfiguration(servletContext, externalContext, expressionFactory);
        }

        public AbstractMyFacesTestCase getTestCase() {
            return this.testCase;
        }
    }

    protected class MyFacesMockFacesConfigurationProvider
    extends DefaultFacesConfigurationProvider {
        private AbstractMyFacesTestCase testCase;

        public MyFacesMockFacesConfigurationProvider(AbstractMyFacesTestCase testCase) {
            this.testCase = testCase;
        }

        public FacesConfig getStandardFacesConfig(ExternalContext ectx) {
            if (standardFacesConfig == null) {
                FacesConfig sfc = super.getStandardFacesConfig(ectx);
                FactoryImpl factory = (FactoryImpl)sfc.getFactories().get(0);
                factory.getViewDeclarationLanguageFactory().set(0, MockMyFacesViewDeclarationLanguageFactory.class.getName());
                standardFacesConfig = sfc;
            }
            return standardFacesConfig;
        }

        public FacesConfig getAnnotationsFacesConfig(ExternalContext ectx, boolean metadataComplete) {
            FacesConfig facesConfig = AbstractMyFacesTestCase.this.jsfConfiguration.getAnnotationsFacesConfig();
            if (facesConfig == null) {
                PageBean annoPageBean;
                ManagedBeans annoManagedBeans;
                if (AbstractMyFacesTestCase.this.isScanAnnotations()) {
                    facesConfig = super.getAnnotationsFacesConfig(ectx, metadataComplete);
                }
                if ((annoManagedBeans = AbstractMyFacesTestCase.this.getTestJavaClass().getAnnotation(ManagedBeans.class)) != null) {
                    if (facesConfig == null) {
                        facesConfig = new FacesConfigImpl();
                    }
                    for (PageBean annoPageBean2 : annoManagedBeans.value()) {
                        ManagedBeanImpl bean = new ManagedBeanImpl();
                        bean.setBeanClass(annoPageBean2.clazz().getName());
                        bean.setName(annoPageBean2.name() == null ? annoPageBean2.clazz().getName() : annoPageBean2.name());
                        bean.setScope(annoPageBean2.scope() == null ? "request" : annoPageBean2.scope());
                        bean.setEager(Boolean.toString(annoPageBean2.eager()));
                        ((FacesConfigImpl)facesConfig).addManagedBean((ManagedBean)bean);
                    }
                }
                if ((annoPageBean = AbstractMyFacesTestCase.this.getTestJavaClass().getAnnotation(PageBean.class)) != null) {
                    if (facesConfig == null) {
                        facesConfig = new FacesConfigImpl();
                    }
                    ManagedBeanImpl bean = new ManagedBeanImpl();
                    bean.setBeanClass(annoPageBean.clazz().getName());
                    bean.setName(annoPageBean.name() == null ? annoPageBean.clazz().getName() : annoPageBean.name());
                    bean.setScope(annoPageBean.scope() == null ? "request" : annoPageBean.scope());
                    bean.setEager(Boolean.toString(annoPageBean.eager()));
                    ((FacesConfigImpl)facesConfig).addManagedBean((ManagedBean)bean);
                }
                AbstractMyFacesTestCase.this.jsfConfiguration.setAnnotationFacesConfig(facesConfig);
            }
            return facesConfig;
        }

        public List<FacesConfig> getClassloaderFacesConfig(ExternalContext ectx) {
            List list = AbstractMyFacesTestCase.this.jsfConfiguration.getClassloaderFacesConfig();
            if (list == null) {
                list = super.getClassloaderFacesConfig(ectx);
                AbstractMyFacesTestCase.this.jsfConfiguration.setClassloaderFacesConfig(list);
            }
            return list;
        }

        public List<FacesConfig> getFaceletTaglibFacesConfig(ExternalContext externalContext) {
            List list = AbstractMyFacesTestCase.this.jsfConfiguration.getFaceletTaglibFacesConfig();
            if (list == null) {
                list = super.getFaceletTaglibFacesConfig(externalContext);
                AbstractMyFacesTestCase.this.jsfConfiguration.setFaceletTaglibFacesConfig(list);
            }
            return list;
        }

        public List<FacesConfig> getFacesFlowFacesConfig(ExternalContext ectx) {
            List list = AbstractMyFacesTestCase.this.jsfConfiguration.getFacesFlowFacesConfig();
            if (list == null) {
                list = super.getFacesFlowFacesConfig(ectx);
                AbstractMyFacesTestCase.this.jsfConfiguration.setFacesFlowFacesConfig(list);
            }
            return list;
        }

        public FacesConfig getMetaInfServicesFacesConfig(ExternalContext ectx) {
            FacesConfig facesConfig = AbstractMyFacesTestCase.this.jsfConfiguration.getMetaInfServicesFacesConfig();
            if (facesConfig == null) {
                facesConfig = super.getMetaInfServicesFacesConfig(ectx);
            }
            return facesConfig;
        }

        public List<FacesConfig> getContextSpecifiedFacesConfig(ExternalContext ectx) {
            List appConfigResources = super.getContextSpecifiedFacesConfig(ectx);
            DeclareFacesConfig annoFacesConfig = AbstractMyFacesTestCase.this.getTestJavaClass().getAnnotation(DeclareFacesConfig.class);
            if (annoFacesConfig != null) {
                Logger log = Logger.getLogger(AbstractMyFacesTestCase.this.getTestJavaClass().getName());
                try {
                    for (String systemId : annoFacesConfig.value()) {
                        InputStream stream;
                        URL url;
                        if (MyfacesConfig.getCurrentInstance((ExternalContext)ectx).isValidateXML() && (url = ectx.getResource(systemId)) != null) {
                            AbstractMyFacesTestCase.this.validateFacesConfig(ectx, url);
                        }
                        if ((stream = ectx.getResourceAsStream(systemId)) == null) {
                            log.severe("Faces config resource " + systemId + " not found");
                            continue;
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.info("Reading config " + systemId);
                        }
                        appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, systemId));
                        stream.close();
                    }
                }
                catch (Throwable e) {
                    throw new FacesException(e);
                }
            }
            return appConfigResources;
        }
    }
}

