/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.mc.test.core.mock;

import java.beans.BeanInfo;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.shared.application.InvalidViewIdException;

public class MockDefaultViewDeclarationLanguage
extends ViewDeclarationLanguage {
    public static final String DUMMY_VIEW_CREATE_HOOK = "oam.dummy.create.UIViewRoot";
    public static final String DUMMY_VIEW_RESTORE_HOOK = "oam.dummy.restore.UIViewRoot";

    public void buildView(FacesContext context, UIViewRoot view) throws IOException {
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (context.getAttributes().containsKey(DUMMY_VIEW_CREATE_HOOK)) {
            UIViewRoot root = (UIViewRoot)context.getAttributes().remove(DUMMY_VIEW_CREATE_HOOK);
            Application application = context.getApplication();
            ViewHandler handler = application.getViewHandler();
            root.setLocale(handler.calculateLocale(context));
            root.setRenderKitId(handler.calculateRenderKitId(context));
            root.setViewId(viewId);
            return root;
        }
        try {
            viewId = this.calculateViewId(context, viewId);
            Application application = context.getApplication();
            UIViewRoot newViewRoot = (UIViewRoot)application.createComponent("javax.faces.ViewRoot");
            UIViewRoot oldViewRoot = context.getViewRoot();
            if (oldViewRoot == null) {
                ViewHandler handler = application.getViewHandler();
                newViewRoot.setLocale(handler.calculateLocale(context));
                newViewRoot.setRenderKitId(handler.calculateRenderKitId(context));
            } else {
                newViewRoot.setLocale(oldViewRoot.getLocale());
                newViewRoot.setRenderKitId(oldViewRoot.getRenderKitId());
            }
            newViewRoot.setViewId(viewId);
            return newViewRoot;
        }
        catch (InvalidViewIdException e) {
            this.sendSourceNotFound(context, e.getMessage());
            return null;
        }
    }

    protected String calculateViewId(FacesContext context, String viewId) {
        if (viewId != null) {
            throw new InvalidViewIdException();
        }
        return null;
    }

    protected void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    public static void hookCreateView(FacesContext context, UIViewRoot root) {
        context.getAttributes().put(DUMMY_VIEW_CREATE_HOOK, root);
    }

    public static void hookRestoreView(FacesContext context, UIViewRoot root) {
        context.getAttributes().put(DUMMY_VIEW_RESTORE_HOOK, root);
    }

    public BeanInfo getComponentMetadata(FacesContext context, Resource componentResource) {
        return null;
    }

    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        return null;
    }

    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        return null;
    }

    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        return null;
    }

    public void renderView(FacesContext context, UIViewRoot view) throws IOException {
        this.checkNull(context, "context");
        this.checkNull(view, "view");
        ExternalContext externalContext = context.getExternalContext();
        ResponseWriter responseWriter = context.getResponseWriter();
        if (responseWriter == null) {
            RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderFactory.getRenderKit(context, view.getRenderKitId());
            responseWriter = renderKit.createResponseWriter(externalContext.getResponseOutputWriter(), null, externalContext.getRequestCharacterEncoding());
            context.setResponseWriter(responseWriter);
        }
        responseWriter.startDocument();
        view.encodeAll(context);
        responseWriter.endDocument();
        responseWriter.flush();
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.checkNull(context, "context");
        if (context.getAttributes().containsKey(DUMMY_VIEW_RESTORE_HOOK)) {
            UIViewRoot root = (UIViewRoot)context.getAttributes().remove(DUMMY_VIEW_RESTORE_HOOK);
            root.setViewId(viewId);
            return root;
        }
        Application application = context.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(context);
        UIViewRoot viewRoot = application.getStateManager().restoreView(context, viewId, renderKitId);
        return viewRoot;
    }

    protected void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }
}

