/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.mc.test.core.mock;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import org.apache.myfaces.mc.test.core.AbstractMyFacesRequestTestCase;
import org.apache.myfaces.mc.test.core.mock.ServletMockContainer;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpServletResponse;
import org.junit.Assert;

public class MockMyFacesClient {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private Map<String, Object> headers = new HashMap<String, Object>();
    private ServletMockContainer testCase;

    public MockMyFacesClient(FacesContext facesContext, ServletMockContainer testCase) {
        this.testCase = testCase;
    }

    public void processRedirect() {
        MockHttpServletResponse response = this.testCase.getResponse();
        MockHttpServletRequest request = this.testCase.getRequest();
        if (response.getStatus() == 302) {
            this.testCase.processRemainingPhases();
            this.testCase.endRequest();
            String location = response.getHeader("Location");
            String contextPath = request.getContextPath() == null ? "" : request.getContextPath();
            String servletPath = request.getServletPath() == null ? "" : request.getServletPath();
            int cpi = location.indexOf(contextPath);
            int spi = cpi < 0 ? -1 : location.indexOf(servletPath, cpi + contextPath.length());
            String viewId = spi >= 0 ? location.substring(spi + servletPath.length()) : location;
            this.testCase.startViewRequest(viewId);
        } else {
            Assert.fail((String)"Expected redirect not found");
        }
    }

    public void inputText(UIInput input, String text) {
        this.parameters.put(input.getClientId(), text);
    }

    public void inputText(String clientId, String text) {
        UIComponent input = this.getTestCase().getFacesContext().getViewRoot().findComponent(clientId);
        if (input == null) {
            throw new FacesException("input with clientId:" + clientId + " not found");
        }
        this.parameters.put(input.getClientId(), text);
    }

    public void submit(UIComponent component) {
        this.testCase.processRemainingPhases();
        this.internalSubmit((UICommand)component);
        String viewId = this.testCase.getFacesContext().getViewRoot().getViewId();
        this.testCase.endRequest();
        this.testCase.startViewRequest(viewId);
    }

    public void submit(String clientId) {
        UIComponent button = this.getTestCase().getFacesContext().getViewRoot().findComponent(clientId);
        if (button == null) {
            throw new FacesException("button with clientId:" + clientId + " not found");
        }
        this.submit(button);
    }

    protected void internalSubmit(UICommand command) {
        if (command instanceof HtmlCommandButton) {
            final FacesContext facesContext = this.testCase.getFacesContext();
            UIForm form = this.getParentForm((UIComponent)command);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext);
            form.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    if (target instanceof UIInput && !MockMyFacesClient.this.parameters.containsKey(target.getClientId(facesContext))) {
                        MockMyFacesClient.this.parameters.put(target.getClientId(facesContext), RendererUtils.getStringValue((FacesContext)facesContext, (UIComponent)target));
                    }
                    return VisitResult.ACCEPT;
                }
            });
            this.parameters.put(form.getClientId(facesContext) + "_SUBMIT", "1");
            Object value = command.getValue();
            this.parameters.put(command.getClientId(), value == null ? "" : value.toString());
            this.applyStateFromPreviousRequest();
        }
    }

    public void ajax(UIComponent source, String event, String execute, String render, boolean submit) throws Exception {
        this.ajax(source, event, execute, render, submit, false);
    }

    public void ajax(UIComponent source, String event, String execute, String render, boolean submit, boolean resetValues) {
        this.testCase.processRemainingPhases();
        this.internalAjax(source, event, execute, render, submit, resetValues);
        String viewId = this.testCase.getFacesContext().getViewRoot().getViewId();
        this.testCase.endRequest();
        this.testCase.startViewRequest(viewId);
    }

    protected void internalAjax(UIComponent source, String event, String execute, String render, boolean submit, boolean resetValues) {
        FacesContext facesContext = this.testCase.getFacesContext();
        this.parameters.put("javax.faces.partial.ajax", "true");
        this.parameters.put("javax.faces.behavior.event", event);
        this.parameters.put("javax.faces.partial.event", "action".equals(event) ? "click" : event);
        this.applyStateFromPreviousRequest();
        this.parameters.put("javax.faces.source", source.getClientId(facesContext));
        if (execute == null) {
            this.parameters.put("javax.faces.partial.execute", source.getClientId(facesContext));
        } else {
            this.parameters.put("javax.faces.partial.execute", execute);
        }
        if (render != null) {
            this.parameters.put("javax.faces.partial.render", render);
        }
        if (submit) {
            this.parameters.put(source.getClientId(facesContext) + "_SUBMIT", "1");
            this.parameters.put(source.getClientId(facesContext), source.getClientId(facesContext));
        }
        if (resetValues) {
            this.parameters.put("javax.faces.partial.resetValues", "true");
        }
        this.headers.put("Faces-Request", "partial/ajax");
        this.headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
    }

    protected void applyStateFromPreviousRequest() {
        FacesContext facesContext = this.testCase.getFacesContext();
        this.parameters.put("javax.faces.ViewState", facesContext.getApplication().getStateManager().getViewState(facesContext));
        if (facesContext.getExternalContext().getClientWindow() != null) {
            this.parameters.put("jfwid", facesContext.getExternalContext().getClientWindow().getId());
        }
        this.applyCookiesFromPreviousRequest();
    }

    protected void applyCookiesFromPreviousRequest() {
        MockHttpServletResponse response = this.testCase.getResponse();
        if (response.getCookies() != null && !response.getCookies().isEmpty()) {
            for (Map.Entry entry : response.getCookies().entrySet()) {
                this.getCookies().put((String)entry.getKey(), (Cookie)entry.getValue());
            }
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    private UIForm getParentForm(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            return (UIForm)parent;
        }
        return null;
    }

    public void apply(MockHttpServletRequest request) {
        Map<String, String> inputFields = this.getParameters();
        for (Map.Entry<String, String> entry : inputFields.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        Map<String, Object> headerFields = this.getHeaders();
        for (Map.Entry<String, Object> entry : headerFields.entrySet()) {
            if (entry.getValue() instanceof String) {
                request.addHeader(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                request.addIntHeader(entry.getKey(), ((Integer)entry.getValue()).intValue());
                continue;
            }
            if (!(entry.getValue() instanceof Date)) continue;
            request.addDateHeader(entry.getKey(), ((Date)entry.getValue()).getTime());
        }
        Map<String, Cookie> cookies = this.getCookies();
        for (Map.Entry<String, Cookie> entry : cookies.entrySet()) {
            request.addCookie(entry.getValue());
        }
    }

    public void reset(FacesContext facesContext) {
        this.parameters.clear();
        this.headers.clear();
        this.cookies.clear();
    }

    public ServletMockContainer getTestCase() {
        return this.testCase;
    }

    public void setTestCase(AbstractMyFacesRequestTestCase testCase) {
        this.testCase = testCase;
    }
}

