/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import java.io.IOException;
import java.io.StringWriter;
import java.text.ParsePosition;
import java.util.ArrayList;

class ExpressionTokenizer {
    private ExpressionTokenizer() {
    }

    public static String[] tokenize(CharSequence expr) {
        ArrayList<String> tokens = new ArrayList<String>();
        ParsePosition pos = new ParsePosition(0);
        int len = expr.length();
        boolean sep = true;
        while (pos.getIndex() < len) {
            int here = pos.getIndex();
            char c = expr.charAt(here);
            switch (c) {
                case ' ': {
                    ExpressionTokenizer.next(pos);
                    break;
                }
                case ']': {
                    throw new IllegalStateException(String.format("Position %s: unexpected '%s'", here, Character.valueOf(c)));
                }
                case '[': {
                    tokens.add(ExpressionTokenizer.parseIndex(expr, ExpressionTokenizer.next(pos)));
                    break;
                }
                case '.': {
                    if (sep) {
                        throw new IllegalStateException(String.format("Position %s: expected property, index/key, or end of expression", here));
                    }
                    sep = true;
                    ExpressionTokenizer.next(pos);
                }
                default: {
                    if (!sep) {
                        throw new IllegalStateException(String.format("Position %s: expected property path separator, index/key, or end of expression", here));
                    }
                    tokens.add(ExpressionTokenizer.parseProperty(expr, pos));
                }
            }
            sep = false;
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static ParsePosition next(ParsePosition pos) {
        pos.setIndex(pos.getIndex() + 1);
        return pos;
    }

    private static String parseProperty(CharSequence expr, ParsePosition pos) {
        int len = expr.length();
        int start = pos.getIndex();
        block3: while (pos.getIndex() < len) {
            switch (expr.charAt(pos.getIndex())) {
                case '.': 
                case '[': 
                case ']': {
                    break block3;
                }
                default: {
                    ExpressionTokenizer.next(pos);
                    continue block3;
                }
            }
        }
        if (pos.getIndex() > start) {
            return expr.subSequence(start, pos.getIndex()).toString();
        }
        throw new IllegalStateException(String.format("Position %s: expected property", start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseIndex(CharSequence expr, ParsePosition pos) {
        int len = expr.length();
        int start = pos.getIndex();
        if (start < len) {
            String s;
            char first = expr.charAt(pos.getIndex());
            if ((first == '\"' || first == '\'') && (s = ExpressionTokenizer.parseQuotedString(expr, pos)) != null && expr.charAt(pos.getIndex()) == ']') {
                ExpressionTokenizer.next(pos);
                return s;
            }
            while (pos.getIndex() < len) {
                int here = pos.getIndex();
                try {
                    if (expr.charAt(here) != ']') continue;
                    String string = expr.subSequence(start, here).toString().trim();
                    return string;
                }
                finally {
                    ExpressionTokenizer.next(pos);
                }
            }
        }
        throw new IllegalStateException(String.format("Position %s: unparsable index", start));
    }

    private static String parseQuotedString(CharSequence expr, ParsePosition pos) {
        int len = expr.length();
        int start = pos.getIndex();
        if (start < len) {
            char quote = expr.charAt(start);
            ExpressionTokenizer.next(pos);
            StringWriter w = new StringWriter();
            while (pos.getIndex() < len) {
                int here = pos.getIndex();
                char c = expr.charAt(here);
                boolean esc = false;
                if (c == '\\' && here + 1 < len && expr.charAt(here + 1) == quote) {
                    esc = true;
                    here = ExpressionTokenizer.next(pos).getIndex();
                }
                try {
                    if (c == quote && !esc) {
                        String string = w.toString();
                        return string;
                    }
                    w.write(Character.toChars(Character.codePointAt(expr, here)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ExpressionTokenizer.next(pos);
                }
            }
            pos.setIndex(start);
        }
        return null;
    }
}

