/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.StateManager;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.convert.Converter;
import jakarta.faces.event.ActionListener;
import jakarta.faces.validator.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.myfaces.test.mock.MockActionListener;
import org.apache.myfaces.test.mock.MockNavigationHandler;
import org.apache.myfaces.test.mock.MockStateManager;
import org.apache.myfaces.test.mock.MockViewHandler;

public abstract class MockApplication10
extends Application {
    private ActionListener actionListener = null;
    private Map components = null;
    private Map converters = null;
    private Map converters1 = null;
    private Locale defaultLocale = null;
    private String defaultRenderKitId = null;
    private String messageBundle = null;
    private NavigationHandler navigationHandler = null;
    private StateManager stateManager = null;
    private Collection supportedLocales = null;
    private Map validators = null;
    private ViewHandler viewHandler = null;

    public MockApplication10() {
        this.setActionListener(new MockActionListener());
        this.components = new HashMap();
        this.converters = new HashMap();
        this.converters1 = new HashMap();
        this.setDefaultLocale(Locale.getDefault());
        this.setDefaultRenderKitId("HTML_BASIC");
        this.setNavigationHandler(new MockNavigationHandler());
        this.setStateManager(new MockStateManager());
        this.setSupportedLocales(new ArrayList());
        this.validators = new HashMap();
        this.setViewHandler(new MockViewHandler());
        this.addConverter("jakarta.faces.BigDecimal", "jakarta.faces.convert.BigDecimalConverter");
        this.addConverter("jakarta.faces.BigInteger", "jakarta.faces.convert.BigIntegerConverter");
        this.addConverter("jakarta.faces.Boolean", "jakarta.faces.convert.BooleanConverter");
        this.addConverter("jakarta.faces.Byte", "jakarta.faces.convert.ByteConverter");
        this.addConverter("jakarta.faces.Character", "jakarta.faces.convert.CharacterConverter");
        this.addConverter("jakarta.faces.DateTime", "jakarta.faces.convert.DateTimeConverter");
        this.addConverter("jakarta.faces.Double", "jakarta.faces.convert.DoubleConverter");
        this.addConverter("jakarta.faces.Float", "jakarta.faces.convert.FloatConverter");
        this.addConverter("jakarta.faces.Integer", "jakarta.faces.Convert.IntegerConverter");
        this.addConverter("jakarta.faces.Long", "jakarta.faces.convert.LongConverter");
        this.addConverter("jakarta.faces.Number", "jakarta.faces.convert.NumberConverter");
        this.addConverter("jakarta.faces.Short", "jakarta.faces.convert.ShortConverter");
        this.addConverter(Boolean.class, "jakarta.faces.convert.BooleanConverter");
        this.addConverter(Boolean.TYPE, "jakarta.faces.convert.BooleanConverter");
        this.addConverter(Byte.class, "jakarta.faces.convert.ByteConverter");
        this.addConverter(Byte.TYPE, "jakarta.faces.convert.ByteConverter");
        this.addConverter(Character.class, "jakarta.faces.convert.CharacterConverter");
        this.addConverter(Character.TYPE, "jakarta.faces.convert.CharacterConverter");
        this.addConverter(Double.class, "jakarta.faces.convert.DoubleConverter");
        this.addConverter(Double.TYPE, "jakarta.faces.convert.DoubleConverter");
        this.addConverter(Float.class, "jakarta.faces.convert.FloatConverter");
        this.addConverter(Float.TYPE, "jakarta.faces.convert.FloatConverter");
        this.addConverter(Integer.class, "jakarta.faces.convert.IntegerConverter");
        this.addConverter(Integer.TYPE, "jakarta.faces.convert.IntegerConverter");
        this.addConverter(Long.class, "jakarta.faces.convert.LongConverter");
        this.addConverter(Long.TYPE, "jakarta.faces.convert.LongConverter");
        this.addConverter(Short.class, "jakarta.faces.convert.ShortConverter");
        this.addConverter(Short.TYPE, "jakarta.faces.convert.ShortConverter");
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String defaultRenderKitId) {
        this.defaultRenderKitId = defaultRenderKitId;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public void setMessageBundle(String messageBundle) {
        this.messageBundle = messageBundle;
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler;
    }

    public void setNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public Iterator getSupportedLocales() {
        return this.supportedLocales.iterator();
    }

    public void setSupportedLocales(Collection supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public void addComponent(String componentType, String componentClass) {
        this.components.put(componentType, componentClass);
    }

    public UIComponent createComponent(String componentType) {
        if (componentType == null) {
            throw new NullPointerException("Requested component type is null");
        }
        String componentClass = (String)this.components.get(componentType);
        if (componentClass == null) {
            throw new FacesException("No component class registered for component type '" + componentType + '\'');
        }
        try {
            Class<?> clazz = Class.forName(componentClass);
            return (UIComponent)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getComponentTypes() {
        return this.components.keySet().iterator();
    }

    public void addConverter(String converterId, String converterClass) {
        this.converters.put(converterId, converterClass);
    }

    public void addConverter(Class targetClass, String converterClass) {
        this.converters1.put(targetClass, converterClass);
    }

    public Converter createConverter(String converterId) {
        String converterClass = (String)this.converters.get(converterId);
        if (converterClass == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(converterClass);
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Converter createConverter(Class targetClass) {
        String converterClass = (String)this.converters1.get(targetClass);
        if (converterClass == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(converterClass);
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getConverterIds() {
        return this.converters.keySet().iterator();
    }

    public Iterator getConverterTypes() {
        return this.converters1.keySet().iterator();
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.validators.put(validatorId, validatorClass);
    }

    public Validator createValidator(String validatorId) {
        String validatorClass = (String)this.validators.get(validatorId);
        try {
            Class<?> clazz = Class.forName(validatorClass);
            return (Validator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getValidatorIds() {
        return this.validators.keySet().iterator();
    }
}

