/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionContext;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.Enumeration;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.MockWebContainer;

public class MockHttpSessionProxy
extends MockHttpSession {
    private MockServletContext servletContext;
    private MockHttpServletRequest request;
    private MockHttpSession delegate;

    public MockHttpSessionProxy(MockServletContext servletContext, MockHttpServletRequest request) {
        super(servletContext);
        this.servletContext = servletContext;
    }

    @Override
    public void addAttributeListener(HttpSessionAttributeListener listener) {
        this.getWrapped().addAttributeListener(listener);
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        if (servletContext instanceof MockServletContext) {
            this.servletContext = (MockServletContext)servletContext;
        }
        this.getWrapped().setServletContext(servletContext);
    }

    @Override
    public void setId(String id) {
        this.getWrapped().setId(id);
    }

    @Override
    public Object getAttribute(String name) {
        return this.getWrapped().getAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this.getWrapped().getAttributeNames();
    }

    @Override
    public long getCreationTime() {
        return this.getWrapped().getCreationTime();
    }

    @Override
    public String getId() {
        return this.getWrapped().getId();
    }

    @Override
    public long getLastAccessedTime() {
        return this.getWrapped().getLastAccessedTime();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.getWrapped().getMaxInactiveInterval();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext == null ? this.getWrapped().getServletContext() : this.servletContext;
    }

    @Override
    public HttpSessionContext getSessionContext() {
        return this.getWrapped().getSessionContext();
    }

    @Override
    public Object getValue(String name) {
        return this.getWrapped().getValue(name);
    }

    @Override
    public String[] getValueNames() {
        return this.getWrapped().getValueNames();
    }

    @Override
    public void invalidate() {
        this.getWrapped().invalidate();
    }

    @Override
    public boolean isNew() {
        return this.getWrapped().isNew();
    }

    @Override
    public void putValue(String name, Object value) {
        this.getWrapped().putValue(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.getWrapped().removeAttribute(name);
    }

    @Override
    public void removeValue(String name) {
        this.getWrapped().removeValue(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.getWrapped().setAttribute(name, value);
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.getWrapped().setMaxInactiveInterval(interval);
    }

    public MockHttpSession getWrapped() {
        if (this.delegate == null) {
            if (this.request != null) {
                this.delegate = (MockHttpSession)this.request.getSession(true);
            } else {
                this.delegate = new MockHttpSession(this.servletContext);
                MockWebContainer container = this.getWebContainer();
                if (container != null) {
                    HttpSessionEvent se = new HttpSessionEvent((HttpSession)this.delegate);
                    container.sessionCreated(se);
                }
            }
        }
        return this.delegate;
    }

    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(MockHttpServletRequest request) {
        this.request = request;
    }
}

