/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.application.Application;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.el.MethodNotFoundException;
import jakarta.faces.el.ReferenceSyntaxException;
import jakarta.faces.el.ValueBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MockMethodBinding
extends MethodBinding
implements StateHolder {
    private Application application;
    private Class[] args;
    private String name;
    private String ref;
    private ValueBinding vb;
    private boolean transientFlag = false;

    public MockMethodBinding() {
    }

    public MockMethodBinding(Application application, String ref, Class[] args) {
        this.application = application;
        this.args = args;
        if (ref.startsWith("#{") && ref.endsWith("}")) {
            ref = ref.substring(2, ref.length() - 1);
        }
        this.ref = ref;
        int period = ref.lastIndexOf(".");
        if (period < 0) {
            throw new ReferenceSyntaxException(ref);
        }
        this.vb = application.createValueBinding(ref.substring(0, period));
        this.name = ref.substring(period + 1);
        if (this.name.length() < 1) {
            throw new ReferenceSyntaxException(ref);
        }
    }

    public Object invoke(FacesContext context, Object[] params) throws EvaluationException, MethodNotFoundException {
        if (context == null) {
            throw new NullPointerException();
        }
        Object base = this.vb.getValue(context);
        if (base == null) {
            throw new EvaluationException("Cannot find object via expression \"" + this.vb.getExpressionString() + "\"");
        }
        Method method = this.method(base);
        try {
            return method.invoke(base, params);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
    }

    public Class getType(FacesContext context) {
        Object base = this.vb.getValue(context);
        Method method = this.method(base);
        Class<?> returnType = method.getReturnType();
        if ("void".equals(returnType.getName())) {
            return null;
        }
        return returnType;
    }

    public String getExpressionString() {
        return "#{" + this.ref + "}";
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.name, this.ref, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.vb), this.args};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.name = (String)values[0];
        this.ref = (String)values[1];
        this.vb = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.args = (Class[])values[3];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public int hashCode() {
        if (this.ref == null) {
            return 0;
        }
        return this.ref.hashCode();
    }

    public boolean equals(Object otherObj) {
        MockMethodBinding other = null;
        if (!(otherObj instanceof MockMethodBinding)) {
            return false;
        }
        other = (MockMethodBinding)((Object)otherObj);
        if (this.ref != other.ref) {
            if (null != this.ref && null != other.ref && !this.ref.equals(other.ref)) {
                return false;
            }
            return false;
        }
        if (this.args != other.args) {
            if (this.args.length != other.args.length) {
                return false;
            }
            int len = this.args.length;
            for (int i = 0; i < len; ++i) {
                if (this.args[i] == other.args[i] || this.ref.equals(other.ref)) continue;
                return false;
            }
        }
        return true;
    }

    Method method(Object base) {
        Class<?> clazz = base.getClass();
        try {
            return clazz.getMethod(this.name, this.args);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(this.ref + ": " + e.getMessage());
        }
    }
}

