/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.context.ResponseStream;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.Renderer;
import jakarta.faces.render.ResponseStateManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.test.mock.MockResponseStateManager;
import org.apache.myfaces.test.mock.MockResponseWriter;

public class MockRenderKit
extends RenderKit {
    private Map renderers = new HashMap();
    private ResponseStateManager rsm = new MockResponseStateManager();

    public void setResponseStateManager(ResponseStateManager rsm) {
        this.rsm = rsm;
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null || rendererType == null || renderer == null) {
            throw new NullPointerException();
        }
        this.renderers.put(family + '|' + rendererType, renderer);
    }

    public Renderer getRenderer(String family, String rendererType) {
        if (family == null || rendererType == null) {
            throw new NullPointerException();
        }
        return (Renderer)this.renderers.get(family + '|' + rendererType);
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        return new MockResponseWriter(writer, contentTypeList, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        final OutputStream stream = out;
        return new ResponseStream(){

            public void close() throws IOException {
                stream.close();
            }

            public void flush() throws IOException {
                stream.flush();
            }

            public void write(byte[] b) throws IOException {
                stream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                stream.write(b, off, len);
            }

            public void write(int b) throws IOException {
                stream.write(b);
            }
        };
    }

    public ResponseStateManager getResponseStateManager() {
        return this.rsm;
    }
}

