/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.SystemEventListenerHolder;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.test.mock.MockApplication12;
import org.apache.myfaces.test.mock.MockViewHandler20;
import org.apache.myfaces.test.mock._ELText;
import org.apache.myfaces.test.mock.resource.MockResourceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockApplication20
extends MockApplication12 {
    private static final Log log = LogFactory.getLog(MockApplication20.class);
    private final Map<Class<? extends SystemEvent>, SystemListenerEntry> _systemEventListenerClassMap = new ConcurrentHashMap<Class<? extends SystemEvent>, SystemListenerEntry>();
    private Map<String, String> _defaultValidatorsIds = new HashMap<String, String>();
    private ProjectStage _projectStage;
    private final Map<String, Class<?>> _behaviorClassMap = new ConcurrentHashMap();
    private final Map<String, Class<?>> _validatorClassMap = new ConcurrentHashMap();
    private ResourceHandler _resourceHandler;

    public MockApplication20() {
        this.setViewHandler(new MockViewHandler20());
        this.setResourceHandler(new MockResourceHandler());
    }

    public Map<String, String> getDefaultValidatorInfo() {
        return Collections.unmodifiableMap(this._defaultValidatorsIds);
    }

    private void _handleAnnotations(FacesContext context, Object inspected, UIComponent component) {
        boolean isProduction = context.isProjectStage(ProjectStage.Production);
        Class<?> inspectedClass = inspected.getClass();
        this._handleListenerForAnnotations(context, inspected, inspectedClass, component, isProduction);
        this._handleResourceDependencyAnnotations(context, inspectedClass, component, isProduction);
    }

    private void _handleListenerForAnnotations(FacesContext context, Object inspected, Class<?> inspectedClass, UIComponent component, boolean isProduction) {
        ArrayList<ListenerFor> listenerForList = null;
        if (listenerForList == null) {
            ListenerFor listener = inspectedClass.getAnnotation(ListenerFor.class);
            ListenersFor listeners = inspectedClass.getAnnotation(ListenersFor.class);
            if (listener != null || listeners != null) {
                listenerForList = new ArrayList<ListenerFor>();
                if (listener != null) {
                    listenerForList.add(listener);
                }
                if (listeners != null) {
                    listenerForList.addAll(Arrays.asList(listeners.value()));
                }
            }
        }
        if (listenerForList != null) {
            for (ListenerFor listenerFor : listenerForList) {
                this._handleListenerFor(context, inspected, component, listenerFor);
            }
        }
    }

    private void _handleListenerFor(FacesContext context, Object inspected, UIComponent component, ListenerFor annotation) {
        if (annotation != null) {
            if (inspected instanceof ComponentSystemEventListener) {
                component.subscribeToEvent(annotation.systemEventClass(), (ComponentSystemEventListener)inspected);
            } else if (component instanceof SystemEventListener) {
                Application application = context.getApplication();
                if (Void.class.equals((Object)annotation.sourceClass())) {
                    application.subscribeToEvent(annotation.systemEventClass(), (SystemEventListener)inspected);
                } else {
                    application.subscribeToEvent(annotation.systemEventClass(), annotation.sourceClass(), (SystemEventListener)inspected);
                }
            }
        }
    }

    private void _handleResourceDependencyAnnotations(FacesContext context, Class<?> inspectedClass, UIComponent component, boolean isProduction) {
        ArrayList<ResourceDependency> dependencyList = null;
        if (dependencyList == null) {
            ResourceDependency dependency = inspectedClass.getAnnotation(ResourceDependency.class);
            ResourceDependencies dependencies = inspectedClass.getAnnotation(ResourceDependencies.class);
            if (dependency != null || dependencies != null) {
                dependencyList = new ArrayList<ResourceDependency>();
                if (dependency != null) {
                    dependencyList.add(dependency);
                }
                if (dependencies != null) {
                    dependencyList.addAll(Arrays.asList(dependencies.value()));
                }
            }
        }
        if (dependencyList != null) {
            for (ResourceDependency dependency : dependencyList) {
                this._handleResourceDependency(context, component, dependency);
            }
        }
    }

    private void _handleResourceDependency(FacesContext context, UIComponent component, ResourceDependency annotation) {
        if (annotation != null) {
            String target;
            UIOutput output = (UIOutput)this.createComponent("javax.faces.Output");
            String name = annotation.name();
            if (name != null && name.length() > 0) {
                name = _ELText.parse(this.getExpressionFactory(), context.getELContext(), name).toString(context.getELContext());
            }
            String rendererType = context.getApplication().getResourceHandler().getRendererTypeForResourceName(name);
            output.setRendererType(rendererType);
            Map attributes = output.getAttributes();
            attributes.put("name", name);
            String library = annotation.library();
            if (library != null && library.length() > 0) {
                library = _ELText.parse(this.getExpressionFactory(), context.getELContext(), library).toString(context.getELContext());
                if ("this".equals(library)) {
                    Resource resource = (Resource)component.getAttributes().get("javax.faces.application.Resource.ComponentResource");
                    if (resource != null) {
                        attributes.put("library", resource.getLibraryName());
                    }
                } else {
                    attributes.put("library", library);
                }
            }
            if ((target = annotation.target()) != null && target.length() > 0) {
                target = _ELText.parse(this.getExpressionFactory(), context.getELContext(), target).toString(context.getELContext());
                attributes.put("target", target);
                context.getViewRoot().addComponentResource(context, (UIComponent)output, target);
            } else {
                context.getViewRoot().addComponentResource(context, (UIComponent)output);
            }
        }
    }

    private void _inspectRenderer(FacesContext context, UIComponent component, String componentType, String rendererType) {
        Renderer renderer = context.getRenderKit().getRenderer(component.getFamily(), rendererType);
        if (renderer == null) {
            log.error((Object)("renderer cannot be found for component type " + componentType + " and renderer type " + rendererType));
        } else {
            component.setRendererType(rendererType);
            this._handleAnnotations(context, renderer, component);
        }
    }

    private static SystemEvent _traverseListenerList(List<? extends SystemEventListener> listeners, Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (listeners != null && !listeners.isEmpty()) {
            for (SystemEventListener systemEventListener : listeners) {
                if (!systemEventListener.isListenerForSource(source) || !(event = MockApplication20._createEvent(systemEventClass, source, event)).isAppropriateListener((FacesListener)systemEventListener)) continue;
                event.processListener((FacesListener)systemEventListener);
            }
        }
        return event;
    }

    private static SystemEvent _createEvent(Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (event == null) {
            try {
                Constructor<?>[] constructors = systemEventClass.getConstructors();
                Constructor<?> constructor = null;
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length != 1) continue;
                    constructor = c;
                    break;
                }
                if (constructor != null) {
                    event = (SystemEvent)constructor.newInstance(source);
                }
            }
            catch (Exception e) {
                throw new FacesException("Couldn't instanciate system event of type " + systemEventClass.getName(), (Throwable)e);
            }
        }
        return event;
    }

    private void checkNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException(paramName + " cannot be null.");
        }
    }

    private void checkEmpty(String param, String paramName) {
        if (param.length() == 0) {
            throw new NullPointerException("String " + paramName + " cannot be empty.");
        }
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source) {
        this.checkNull(systemEventClass, "systemEventClass");
        this.checkNull(source, "source");
        if (!facesContext.isProcessingEvents()) {
            return;
        }
        try {
            SystemListenerEntry systemListenerEntry;
            UIViewRoot uiViewRoot;
            SystemEvent event = null;
            if (source instanceof SystemEventListenerHolder) {
                SystemEventListenerHolder holder = (SystemEventListenerHolder)source;
                event = MockApplication20._traverseListenerList(holder.getListenersForEventClass(systemEventClass), systemEventClass, source, event);
            }
            if ((uiViewRoot = facesContext.getViewRoot()) != null) {
                event = MockApplication20._traverseListenerList(uiViewRoot.getViewListenersForEventClass(systemEventClass), systemEventClass, source, event);
            }
            if ((systemListenerEntry = this._systemEventListenerClassMap.get(systemEventClass)) != null) {
                systemListenerEntry.publish(systemEventClass, sourceBaseType, source, event);
            }
        }
        catch (AbortProcessingException e) {
            log.error((Object)"Event processing was aborted", (Throwable)e);
        }
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        this.publishEvent(facesContext, systemEventClass, source.getClass(), source);
    }

    public ProjectStage getProjectStage() {
        if (this._projectStage == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            String stageName = context.getExternalContext().getInitParameter("javax.faces.PROJECT_STAGE");
            if (stageName != null) {
                try {
                    this._projectStage = ProjectStage.valueOf((String)stageName);
                    return this._projectStage;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this._projectStage = ProjectStage.Production;
        }
        return this._projectStage;
    }

    public void addBehavior(String behaviorId, String behaviorClass) {
        this.checkNull(behaviorId, "behaviorId");
        this.checkEmpty(behaviorId, "behaviorId");
        this.checkNull(behaviorClass, "behaviorClass");
        this.checkEmpty(behaviorClass, "behaviorClass");
        try {
            this._behaviorClassMap.put(behaviorId, Class.forName(behaviorClass));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Iterator<String> getBehaviorIds() {
        return this._behaviorClassMap.keySet().iterator();
    }

    public Behavior createBehavior(String behaviorId) throws FacesException {
        this.checkNull(behaviorId, "behaviorId");
        this.checkEmpty(behaviorId, "behaviorId");
        Class<?> behaviorClass = this._behaviorClassMap.get(behaviorId);
        if (behaviorClass == null) {
            throw new FacesException("Could not find any registered behavior-class for behaviorId : " + behaviorId);
        }
        try {
            Behavior behavior = (Behavior)behaviorClass.newInstance();
            this._handleAttachedResourceDependencyAnnotations(FacesContext.getCurrentInstance(), behaviorClass);
            return behavior;
        }
        catch (Exception e) {
            throw new FacesException("Could not instantiate behavior: " + behaviorClass, (Throwable)e);
        }
    }

    @Override
    public void addValidator(String validatorId, String validatorClass) {
        super.addValidator(validatorId, validatorClass);
        try {
            this._validatorClassMap.put(validatorId, Class.forName(validatorClass));
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(ex.getMessage());
        }
    }

    public void addDefaultValidatorId(String validatorId) {
        if (this._validatorClassMap.containsKey(validatorId)) {
            this._defaultValidatorsIds.put(validatorId, this._validatorClassMap.get(validatorId).getName());
        }
    }

    public final ResourceHandler getResourceHandler() {
        return this._resourceHandler;
    }

    public final void setResourceHandler(ResourceHandler resourceHandler) {
        this.checkNull(resourceHandler, "resourceHandler");
        this._resourceHandler = resourceHandler;
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.subscribeToEvent(systemEventClass, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        SystemListenerEntry systemListenerEntry;
        this.checkNull(systemEventClass, "systemEventClass");
        this.checkNull(listener, "listener");
        Map<Class<? extends SystemEvent>, SystemListenerEntry> map = this._systemEventListenerClassMap;
        synchronized (map) {
            systemListenerEntry = this._systemEventListenerClassMap.get(systemEventClass);
            if (systemListenerEntry == null) {
                systemListenerEntry = new SystemListenerEntry();
                this._systemEventListenerClassMap.put(systemEventClass, systemListenerEntry);
            }
        }
        systemListenerEntry.addListener(listener, sourceClass);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.unsubscribeFromEvent(systemEventClass, null, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        this.checkNull(systemEventClass, "systemEventClass");
        this.checkNull(listener, "listener");
        SystemListenerEntry systemListenerEntry = this._systemEventListenerClassMap.get(systemEventClass);
        if (systemListenerEntry != null) {
            systemListenerEntry.removeListener(listener, sourceClass);
        }
    }

    @Override
    public UIComponent createComponent(String componentType) {
        UIComponent component = super.createComponent(componentType);
        this._handleAnnotations(FacesContext.getCurrentInstance(), component, component);
        return component;
    }

    @Override
    public UIComponent createComponent(ValueBinding componentBinding, FacesContext context, String componentType) throws FacesException {
        UIComponent component = null;
        try {
            component = (UIComponent)componentBinding.getValue(context);
            if (component == null) {
                component = this.createComponent(componentType);
                componentBinding.setValue(context, (Object)component);
            } else {
                this._handleAnnotations(context, component, component);
            }
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return component;
    }

    @Override
    public UIComponent createComponent(ValueExpression componentExpression, FacesContext facesContext, String componentType) throws FacesException, NullPointerException {
        this.checkNull(componentExpression, "componentExpression");
        this.checkNull(facesContext, "facesContext");
        this.checkNull(componentType, "componentType");
        ELContext elContext = facesContext.getELContext();
        try {
            UIComponent createdComponent;
            Object retVal = componentExpression.getValue(elContext);
            if (retVal instanceof UIComponent) {
                createdComponent = (UIComponent)retVal;
                this._handleAnnotations(facesContext, createdComponent, createdComponent);
            } else {
                createdComponent = this.createComponent(componentType);
                componentExpression.setValue(elContext, (Object)createdComponent);
            }
            return createdComponent;
        }
        catch (FacesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType, String rendererType) {
        UIComponent component = this.createComponent(componentExpression, context, componentType);
        this._inspectRenderer(context, component, componentType, rendererType);
        return component;
    }

    public UIComponent createComponent(FacesContext context, String componentType, String rendererType) {
        this.checkNull(context, "context");
        this.checkNull(componentType, "componentType");
        UIComponent component = this.createComponent(componentType);
        this._inspectRenderer(context, component, componentType, rendererType);
        return component;
    }

    public UIComponent createComponent(FacesContext context, Resource componentResource) {
        this.checkNull(context, "context");
        this.checkNull(componentResource, "componentResource");
        UIComponent component = null;
        Class componentClass = null;
        UIViewRoot view = context.getViewRoot();
        Application application = context.getApplication();
        ViewDeclarationLanguage vdl = application.getViewHandler().getViewDeclarationLanguage(context, view.getViewId());
        BeanInfo metadata = vdl.getComponentMetadata(context, componentResource);
        if (metadata == null) {
            throw new FacesException("Could not get component metadata for " + componentResource.getResourceName() + ". Did you forget to specify <composite:interface>?");
        }
        BeanDescriptor descriptor = metadata.getBeanDescriptor();
        ValueExpression componentType = (ValueExpression)descriptor.getValue("javax.faces.component.COMPOSITE_COMPONENT_TYPE");
        boolean annotationsApplied = false;
        if (componentType != null) {
            component = application.createComponent((String)componentType.getValue(context.getELContext()));
            annotationsApplied = true;
        } else {
            Resource resource = vdl.getScriptComponentResource(context, componentResource);
            if (resource != null) {
                String name = resource.getResourceName();
                String className = name.substring(0, name.lastIndexOf(46));
                try {
                    Class<?> clazz = Class.forName(className);
                    component = (UIComponent)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
            String name = componentResource.getResourceName();
            String className = name.substring(0, name.lastIndexOf(46));
            String fqcn = componentResource.getLibraryName() + "." + className;
            try {
                componentClass = MockApplication20.classForName(fqcn);
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
            if (componentClass != null) {
                try {
                    component = (UIComponent)componentClass.newInstance();
                }
                catch (InstantiationException e) {
                    log.error((Object)("Could not instantiate component class name = " + fqcn), (Throwable)e);
                    throw new FacesException("Could not instantiate component class name = " + fqcn, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Could not instantiate component class name = " + fqcn), (Throwable)e);
                    throw new FacesException("Could not instantiate component class name = " + fqcn, (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)("Could not instantiate component class name = " + fqcn), (Throwable)e);
                }
            }
            if (component == null) {
                component = application.createComponent("javax.faces.NamingContainer");
                annotationsApplied = true;
            }
        }
        component.setRendererType("javax.faces.Composite");
        component.getAttributes().put("javax.faces.application.Resource.ComponentResource", componentResource);
        component.getAttributes().put("javax.faces.component.BEANINFO_KEY", metadata);
        if (!annotationsApplied) {
            this._handleAnnotations(context, component, component);
        }
        return component;
    }

    private static Class classForName(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(type, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, MockApplication20.class.getClassLoader());
        }
    }

    private void _handleAttachedResourceDependencyAnnotations(FacesContext context, Object inspected) {
        if (inspected == null) {
            return;
        }
        ResourceDependency annotation = inspected.getClass().getAnnotation(ResourceDependency.class);
        if (annotation == null) {
            ResourceDependencies dependencies = inspected.getClass().getAnnotation(ResourceDependencies.class);
            if (dependencies != null) {
                for (ResourceDependency dependency : dependencies.value()) {
                    this._handleAttachedResourceDependency(context, dependency);
                }
            }
        } else {
            this._handleAttachedResourceDependency(context, annotation);
        }
    }

    private void _handleAttachedResourceDependency(FacesContext context, ResourceDependency annotation) {
        if (annotation != null) {
            String target;
            Application application = context.getApplication();
            UIOutput output = (UIOutput)application.createComponent("javax.faces.Output");
            String name = annotation.name();
            if (name != null && name.length() > 0) {
                name = _ELText.parse(this.getExpressionFactory(), context.getELContext(), name).toString(context.getELContext());
            }
            String rendererType = application.getResourceHandler().getRendererTypeForResourceName(name);
            output.setRendererType(rendererType);
            Map attributes = output.getAttributes();
            attributes.put("name", name);
            String library = annotation.library();
            if (library != null && library.length() > 0) {
                library = _ELText.parse(this.getExpressionFactory(), context.getELContext(), library).toString(context.getELContext());
                attributes.put("library", library);
            }
            if ((target = annotation.target()) != null && target.length() > 0) {
                target = _ELText.parse(this.getExpressionFactory(), context.getELContext(), target).toString(context.getELContext());
                attributes.put("target", target);
                context.getViewRoot().addComponentResource(context, (UIComponent)output, target);
            } else {
                context.getViewRoot().addComponentResource(context, (UIComponent)output);
            }
        }
    }

    @Override
    public Converter createConverter(String converterId) {
        Converter converter = super.createConverter(converterId);
        this._handleAttachedResourceDependencyAnnotations(FacesContext.getCurrentInstance(), converter);
        return converter;
    }

    @Override
    public Validator createValidator(String validatorId) {
        Validator validator = super.createValidator(validatorId);
        this._handleAttachedResourceDependencyAnnotations(FacesContext.getCurrentInstance(), validator);
        return validator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SystemListenerEntry {
        private List<SystemEventListener> _lstSystemEventListener;
        private Map<Class<?>, List<SystemEventListener>> _sourceClassMap;

        public void addListener(SystemEventListener listener) {
            assert (listener != null);
            this.addListenerNoDuplicate(this.getAnySourceListenersNotNull(), listener);
        }

        public void addListener(SystemEventListener listener, Class<?> source) {
            assert (listener != null);
            if (source == null) {
                this.addListener(listener);
            } else {
                this.addListenerNoDuplicate(this.getSpecificSourceListenersNotNull(source), listener);
            }
        }

        public void removeListener(SystemEventListener listener) {
            assert (listener != null);
            if (this._lstSystemEventListener != null) {
                this._lstSystemEventListener.remove(listener);
            }
        }

        public void removeListener(SystemEventListener listener, Class<?> sourceClass) {
            List<SystemEventListener> listeners;
            assert (listener != null);
            if (sourceClass == null) {
                this.removeListener(listener);
            } else if (this._sourceClassMap != null && (listeners = this._sourceClassMap.get(sourceClass)) != null) {
                listeners.remove(listener);
            }
        }

        public void publish(Class<? extends SystemEvent> systemEventClass, Class<?> classSource, Object source, SystemEvent event) {
            if (source != null && this._sourceClassMap != null) {
                event = MockApplication20._traverseListenerList(this._sourceClassMap.get(classSource), systemEventClass, source, event);
            }
            MockApplication20._traverseListenerList(this._lstSystemEventListener, systemEventClass, source, event);
        }

        private void addListenerNoDuplicate(List<SystemEventListener> listeners, SystemEventListener listener) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }

        private synchronized List<SystemEventListener> getAnySourceListenersNotNull() {
            if (this._lstSystemEventListener == null) {
                this._lstSystemEventListener = new CopyOnWriteArrayList<SystemEventListener>();
            }
            return this._lstSystemEventListener;
        }

        private synchronized List<SystemEventListener> getSpecificSourceListenersNotNull(Class<?> sourceClass) {
            List<SystemEventListener> list;
            if (this._sourceClassMap == null) {
                this._sourceClassMap = new ConcurrentHashMap();
            }
            if ((list = this._sourceClassMap.get(sourceClass)) == null) {
                list = new CopyOnWriteArrayList<SystemEventListener>();
                this._sourceClassMap.put(sourceClass, list);
            }
            return list;
        }
    }
}

