/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.apache.myfaces.test.mock.visit.MockVisitCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPartialViewContext
extends PartialViewContext {
    private static final String FACES_REQUEST = "Faces-Request";
    private static final String PARTIAL_AJAX = "partial/ajax";
    private static final String PARTIAL_PROCESS = "partial/process";
    private static final String SOURCE_PARAM_NAME = "javax.faces.source";
    private FacesContext _facesContext = null;
    private Boolean _ajaxRequest = null;
    private Collection<String> _executeClientIds = null;
    private Collection<String> _renderClientIds = null;
    private Boolean _partialRequest = null;
    private Boolean _renderAll = null;
    private PartialResponseWriter _partialResponseWriter = null;
    private List<String> _evalScripts = new ArrayList<String>();

    public MockPartialViewContext(FacesContext context) {
        this._facesContext = context;
    }

    public boolean isAjaxRequest() {
        if (this._ajaxRequest == null) {
            String requestType = (String)this._facesContext.getExternalContext().getRequestHeaderMap().get(FACES_REQUEST);
            this._ajaxRequest = requestType != null && PARTIAL_AJAX.equals(requestType);
        }
        return this._ajaxRequest;
    }

    public boolean isExecuteAll() {
        String executeMode;
        return this.isAjaxRequest() && "@all".equals(executeMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute"));
    }

    public boolean isPartialRequest() {
        if (this._partialRequest == null) {
            String requestType = (String)this._facesContext.getExternalContext().getRequestHeaderMap().get(FACES_REQUEST);
            this._partialRequest = requestType != null && PARTIAL_PROCESS.equals(requestType);
        }
        return this.isAjaxRequest() || this._partialRequest != false;
    }

    public boolean isRenderAll() {
        if (this._renderAll == null) {
            String executeMode;
            if (this.isAjaxRequest() && "@all".equals(executeMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render"))) {
                this._renderAll = true;
            }
            if (this._renderAll == null) {
                this._renderAll = false;
            }
        }
        return this._renderAll;
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this._partialRequest = isPartialRequest;
    }

    public void setRenderAll(boolean renderAll) {
        this._renderAll = renderAll;
    }

    public Collection<String> getExecuteIds() {
        if (this._executeClientIds == null) {
            String executeMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute");
            if (executeMode != null && !"".equals(executeMode) && !"@all".equals(executeMode)) {
                String[] clientIds = MockPartialViewContext.splitShortString(this._replaceTabOrEnterCharactersWithSpaces(executeMode), ' ');
                ArrayList<String> tempList = new ArrayList<String>();
                for (String clientId : clientIds) {
                    if (clientId.length() <= 0) continue;
                    tempList.add(clientId);
                }
                String source = (String)this._facesContext.getExternalContext().getRequestParameterMap().get(SOURCE_PARAM_NAME);
                if (source != null && !tempList.contains(source = source.trim())) {
                    tempList.add(source);
                }
                this._executeClientIds = tempList;
            } else {
                this._executeClientIds = new ArrayList<String>();
            }
        }
        return this._executeClientIds;
    }

    public Collection<String> getRenderIds() {
        if (this._renderClientIds == null) {
            String renderMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render");
            if (renderMode != null && !"".equals(renderMode) && !"@all".equals(renderMode)) {
                String[] clientIds = MockPartialViewContext.splitShortString(this._replaceTabOrEnterCharactersWithSpaces(renderMode), ' ');
                ArrayList<String> tempList = new ArrayList<String>();
                for (String clientId : clientIds) {
                    if (clientId.length() <= 0) continue;
                    tempList.add(clientId);
                }
                this._renderClientIds = tempList;
            } else {
                this._renderClientIds = new ArrayList<String>();
                if ("@all".equals(renderMode)) {
                    this._renderClientIds.add("javax.faces.ViewRoot");
                }
            }
        }
        return this._renderClientIds;
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this._partialResponseWriter == null) {
            ResponseWriter responseWriter = this._facesContext.getResponseWriter();
            if (responseWriter == null) {
                try {
                    responseWriter = this._facesContext.getRenderKit().createResponseWriter(this._facesContext.getExternalContext().getResponseOutputWriter(), "text/xml", this._facesContext.getExternalContext().getRequestCharacterEncoding());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create Partial Response Writer", e);
                }
            }
            this._partialResponseWriter = responseWriter instanceof PartialResponseWriter ? (PartialResponseWriter)responseWriter : new PartialResponseWriter(responseWriter);
        }
        return this._partialResponseWriter;
    }

    public void processPartial(PhaseId phaseId) {
        UIViewRoot viewRoot = this._facesContext.getViewRoot();
        VisitContext visitCtx = VisitContext.createVisitContext((FacesContext)this._facesContext, null, null);
        viewRoot.visitTree(visitCtx, (VisitCallback)new MockVisitCallback());
    }

    public void release() {
        this._executeClientIds = null;
        this._renderClientIds = null;
        this._ajaxRequest = null;
        this._partialRequest = null;
        this._renderAll = null;
        this._facesContext = null;
        this._evalScripts = new ArrayList<String>();
    }

    public List<String> getEvalScripts() {
        return this._evalScripts;
    }

    private static String[] splitShortString(String str, char separator) {
        int len = str.length();
        int lastTokenIndex = 0;
        int pos = str.indexOf(separator);
        while (pos >= 0) {
            ++lastTokenIndex;
            pos = str.indexOf(separator, pos + 1);
        }
        String[] list = new String[lastTokenIndex + 1];
        int oldPos = 0;
        int pos2 = str.indexOf(separator);
        int i = 0;
        while (pos2 >= 0) {
            list[i++] = str.substring(oldPos, pos2);
            oldPos = pos2 + 1;
            pos2 = str.indexOf(separator, oldPos);
        }
        list[lastTokenIndex] = str.substring(oldPos, len);
        return list;
    }

    private String _replaceTabOrEnterCharactersWithSpaces(String mode) {
        StringBuilder builder = new StringBuilder(mode.length());
        for (int i = 0; i < mode.length(); ++i) {
            if (mode.charAt(i) == '\t' || mode.charAt(i) == '\n') {
                builder.append(' ');
                continue;
            }
            builder.append(mode.charAt(i));
        }
        return builder.toString();
    }
}

