/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.maven.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.myfaces.tobago.maven.plugin.AbstractThemeMojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class UnPackThemeMojo
extends AbstractThemeMojo {
    private ArchiverManager archiverManager;
    private File workDirectory;
    private File webappDirectory;
    private boolean ignoreVersioned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getThemeDescriptor(File jarFile) throws MojoExecutionException {
        block16: {
            ZipFile zip = null;
            try {
                XmlStreamReader xsr;
                zip = new ZipFile(jarFile);
                Enumeration files = zip.getEntries();
                while (files.hasMoreElements()) {
                    String name;
                    ZipEntry nextEntry = (ZipEntry)files.nextElement();
                    if (nextEntry == null || nextEntry.isDirectory() || !(name = nextEntry.getName()).equals("META-INF/tobago-theme.xml") && !name.equals("META-INF/tobago-config.xml")) continue;
                    xsr = null;
                    StringWriter stringWriter = new StringWriter();
                    xsr = ReaderFactory.newXmlReader((InputStream)zip.getInputStream(nextEntry));
                    IOUtil.copy((Reader)xsr, (Writer)stringWriter);
                    String string = stringWriter.toString();
                    IOUtil.close((Reader)xsr);
                    return string;
                }
                break block16;
                catch (Throwable throwable) {
                    try {
                        IOUtil.close(xsr);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error find ThemeDescriptor in " + jarFile, (Exception)e);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return null;
    }

    public void execute() throws MojoExecutionException {
        try {
            Iterator artifacts = this.getProject().getRuntimeClasspathElements().iterator();
            if (!this.workDirectory.exists()) {
                this.workDirectory.mkdirs();
            }
            while (artifacts.hasNext()) {
                String descriptor;
                File file;
                String artifact = (String)artifacts.next();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Testing jar " + artifact));
                }
                if (!(file = new File(artifact)).isFile() || !artifact.endsWith(".jar") || (descriptor = this.getThemeDescriptor(file)) == null) continue;
                String name = file.getName();
                File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
                boolean process = false;
                if (!tempLocation.exists()) {
                    tempLocation.mkdirs();
                    process = true;
                } else if (file.lastModified() > tempLocation.lastModified()) {
                    process = true;
                }
                if (!process) continue;
                try {
                    String[] fileNames;
                    this.unpack(file, tempLocation);
                    String version = null;
                    String resourcePath = null;
                    try {
                        Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)new StringReader(descriptor));
                        Xpp3Dom themeDefinitions = xpp3Dom.getChild("theme-definitions");
                        if (themeDefinitions != null && !this.ignoreVersioned) {
                            for (Xpp3Dom themeDefinition : themeDefinitions.getChildren()) {
                                boolean versioned;
                                Xpp3Dom versionedDom = themeDefinition.getChild("versioned");
                                if (versionedDom == null || !(versioned = Boolean.parseBoolean(versionedDom.getValue()))) continue;
                                Xpp3Dom resourcePathDom = themeDefinition.getChild("resource-path");
                                resourcePath = resourcePathDom.getValue();
                                Properties properties = new Properties();
                                String metaInf = tempLocation + "/META-INF/MANIFEST.MF";
                                properties.load(new ByteArrayInputStream(FileUtils.fileRead((String)metaInf).getBytes()));
                                version = properties.getProperty("Implementation-Version");
                                if (version != null) continue;
                                this.getLog().error((CharSequence)("No Implementation-Version found in Manifest-File for theme: '" + name + "'."));
                            }
                        }
                    }
                    catch (IOException e) {
                        this.getLog().error((Throwable)e);
                    }
                    catch (XmlPullParserException e) {
                        this.getLog().error((Throwable)e);
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Expanding theme: " + name));
                        this.getLog().debug((CharSequence)("Version: " + version));
                        this.getLog().debug((CharSequence)("ResourcePath: " + resourcePath));
                    }
                    for (String fileName : fileNames = this.getThemeFiles(tempLocation)) {
                        File fromFile = new File(tempLocation, fileName);
                        String toFileName = fileName;
                        if (resourcePath != null && version != null && toFileName.startsWith(resourcePath) && !fileName.endsWith("blank.html")) {
                            toFileName = resourcePath + "/" + version + "/" + toFileName.substring(resourcePath.length() + 1);
                        }
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Copy file " + fromFile + " to: " + toFileName));
                        }
                        File toFile = new File(this.webappDirectory, toFileName);
                        try {
                            FileUtils.copyFile((File)fromFile, (File)toFile);
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Error copy file: " + fromFile + " to: " + toFile, (Exception)e);
                        }
                    }
                }
                catch (NoSuchArchiverException e) {
                    this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
                }
            }
        }
        catch (DependencyResolutionRequiredException drre) {
            throw new MojoExecutionException(drre.getMessage(), (Exception)((Object)drre));
        }
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase(Locale.ENGLISH);
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }
}

