/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.context.DateTimeI18n;
import org.apache.myfaces.tobago.internal.util.DateFormatUtils;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.InRenderer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRenderer
extends InRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DateRenderer.class);

    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIInput input) throws IOException {
        super.writeAdditionalAttributes(facesContext, writer, input);
        String pattern = null;
        Converter help = this.getConverter(facesContext, (UIComponent)input);
        if (help instanceof DateTimeConverter) {
            DateTimeConverter converter = (DateTimeConverter)help;
            pattern = DateFormatUtils.findPattern((DateTimeConverter)converter);
        }
        if (pattern == null) {
            pattern = "yyyy-MM-dd";
            LOG.warn("Can't find the pattern for the converter! DatePicker may not work correctly. Trying to use: '" + pattern + "'");
        }
        writer.writeAttribute("data-tobago-pattern", pattern, true);
        DateTimeI18n dateTimeI18n = DateTimeI18n.valueOf((Locale)facesContext.getViewRoot().getLocale());
        writer.writeAttribute("data-tobago-date-time-i18n", JsonUtils.encode(dateTimeI18n), true);
        String imageName = pattern.contains("m") ? (pattern.contains("d") ? "image/date-time" : "image/time") : "image/date";
        String icon = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)imageName);
        if (icon != null) {
            writer.writeAttribute("data-tobago-date-time-icon", icon, true);
        }
        if (TobagoConfig.getInstance((FacesContext)facesContext).isClassicDateTimePicker()) {
            writer.writeAttribute("data-tobago-classic-date-time-picker", "", false);
        }
    }
}

