/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.internal.component.AbstractUIFile;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoMultipartFormdataRequest;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(FileRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        FacesContextUtils.setEnctype((FacesContext)facesContext, (String)"multipart/form-data");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        ServletRequest wrappedRequest;
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        AbstractUIFile input = (AbstractUIFile)component;
        TobagoMultipartFormdataRequest request = null;
        Object requestObject = facesContext.getExternalContext().getRequest();
        if (requestObject instanceof TobagoMultipartFormdataRequest) {
            request = (TobagoMultipartFormdataRequest)requestObject;
        } else if (requestObject instanceof HttpServletRequestWrapper && (wrappedRequest = ((HttpServletRequestWrapper)requestObject).getRequest()) instanceof TobagoMultipartFormdataRequest) {
            request = (TobagoMultipartFormdataRequest)wrappedRequest;
        }
        if (request == null) {
            LOG.error("Can't process multipart/form-data without TobagoRequest. Please check the web.xml and define a TobagoMultipartFormdataFilter. See documentation for <tc:file>");
        } else {
            FileItem item = request.getFileItem(input.getClientId(facesContext));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uploaded file name : \"" + item.getName() + "\"  size = " + item.getSize());
            }
            input.setSubmittedValue((Object)item);
            input.setValid(true);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String title;
        AbstractUIFile file = (AbstractUIFile)component;
        String clientId = file.getClientId(facesContext);
        Style style = new Style(facesContext, (LayoutBase)file);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", (UIComponent)file);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)file));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)file);
        writer.writeStyleAttribute(style);
        Style inputStyle = new Style();
        Measure prettyWidthSub = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)file, "prettyWidthSub");
        inputStyle.setWidth(style.getWidth().subtract(prettyWidthSub));
        writer.startElement("input", (UIComponent)file);
        writer.writeIdAttribute(clientId + "::" + "pretty");
        writer.writeAttribute("type", "text", false);
        writer.writeClassAttribute(Classes.create((UIComponent)file, (String)"pretty"));
        writer.writeStyleAttribute(inputStyle);
        writer.writeAttribute("disabled", true);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)file);
        writer.writeIdAttribute(clientId + "::" + "real");
        writer.writeAttribute("type", "file", false);
        writer.writeClassAttribute(Classes.create((UIComponent)file, (String)"real"));
        writer.writeNameAttribute(clientId);
        writer.writeAttribute("disabled", file.isDisabled() || file.isReadonly());
        writer.writeAttribute("readonly", file.isReadonly());
        writer.writeAttribute("required", file.isRequired());
        writer.writeAttribute("size", "1024", false);
        Integer tabIndex = file.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        if ((title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)file)) != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.endElement("input");
        writer.endElement("div");
    }
}

