/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.internal.layout.LayoutContext;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PopupRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UIPopup popup = (UIPopup)component;
        FacesContextUtils.addPopup((FacesContext)facesContext, (AbstractUIPopup)popup);
        super.prepareRender(facesContext, (UIComponent)popup);
        if (popup.isModal()) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)popup, (Markup)Markup.MODAL);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        UIPopup popup = (UIPopup)component;
        LayoutContext layoutContext = new LayoutContext((LayoutContainer)popup);
        layoutContext.layout();
        if (popup.getCurrentWidth() == null || popup.getCurrentWidth().equals(Measure.ZERO)) {
            LOG.warn("Undefined width of popup with id='" + popup.getClientId(facesContext) + "'");
            popup.setCurrentWidth(this.getPreferredWidth(facesContext, (Configurable)popup));
        }
        if (popup.getCurrentHeight() == null || popup.getCurrentHeight().equals(Measure.ZERO)) {
            LOG.warn("Undefined height of popup with id='" + popup.getClientId(facesContext) + "'");
            popup.setCurrentHeight(this.getPreferredHeight(facesContext, (Configurable)popup));
        }
        String clientId = popup.getClientId(facesContext);
        AbstractUIPage page = ComponentUtils.findPage((FacesContext)facesContext);
        if (popup.getLeft() == null) {
            popup.setLeft(page.getCurrentWidth().subtract(popup.getCurrentWidth()).divide(2));
        }
        if (popup.getTop() == null) {
            popup.setTop(page.getCurrentHeight().subtract(popup.getCurrentHeight()).divide(2));
        }
        writer.startElement("div", (UIComponent)popup);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)popup);
        Style style = new Style(facesContext, (LayoutBase)popup);
        Integer zIndex = popup.getZIndex();
        if (zIndex == null) {
            zIndex = 100;
            LOG.warn("No z-index found for UIPopup. Set to " + zIndex);
        }
        style.setZIndex(zIndex);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)popup));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.endElement("div");
    }
}

