/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UILink;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.component.UISheet;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.event.PageAction;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUIMenu;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.component.AbstractUISheetLayout;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.ToolBarRendererBase;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.EncodeUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.util.FacetUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SheetRenderer.class);
    public static final String WIDTHS_POSTFIX = "::widths";
    public static final String SELECTED_POSTFIX = "::selected";
    private static final Integer HEIGHT_0 = 0;
    private static final String DOTS = "...";

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        this.ensureHeader(facesContext, (UISheet)component);
    }

    private void ensureHeader(FacesContext facesContext, UISheet sheet) {
        UIComponent header = sheet.getHeader();
        if (header == null) {
            header = CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", null, (String)"_header");
            header.setTransient(true);
            List columns = sheet.getAllColumns();
            int i = 0;
            for (AbstractUIColumn column : columns) {
                AbstractUIOut out = (AbstractUIOut)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Out", (String)"Out", (String)("_col" + i));
                out.setTransient(true);
                ValueExpression valueExpression = column.getValueExpression("label");
                if (valueExpression != null) {
                    out.setValueExpression("value", valueExpression);
                } else {
                    out.setValue(column.getAttributes().get("label"));
                }
                valueExpression = column.getValueExpression("rendered");
                if (valueExpression != null) {
                    out.setValueExpression("rendered", valueExpression);
                } else {
                    out.setRendered(((Boolean)column.getAttributes().get("rendered")).booleanValue());
                }
                header.getChildren().add(out);
                ++i;
            }
            sheet.setHeader(header);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String[] clientIds;
        UISheet sheet = (UISheet)uiComponent;
        Style style = new Style(facesContext, (LayoutBase)sheet);
        String sheetId = sheet.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", (UIComponent)sheet);
        writer.writeIdAttribute(sheetId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)sheet);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet));
        writer.writeStyleAttribute(style);
        UIComponent facetReload = sheet.getFacet("reload");
        if (facetReload != null && facetReload instanceof UIReload && facetReload.isRendered()) {
            UIReload update = (UIReload)facetReload;
            writer.writeAttribute("data-tobago-reload", update.getFrequency().intValue());
        }
        if ((clientIds = ComponentUtils.evaluateClientIds((FacesContext)facesContext, (UIComponent)sheet, (String[])sheet.getRenderedPartially())).length > 0) {
            writer.writeAttribute("data-tobago-partial-ids", JsonUtils.encode(clientIds), true);
        }
        writer.writeAttribute("data-tobago-selection-mode", sheet.getSelectable(), false);
        writer.writeAttribute("data-tobago-first", Integer.toString(sheet.getFirst()), false);
        boolean rowAction = HtmlRendererUtils.renderSheetCommands(sheet, facesContext, writer);
        this.renderSheet(facesContext, sheet, rowAction, style);
        writer.endElement("div");
    }

    private void renderSheet(FacesContext facesContext, UISheet sheet, boolean hasClickAction, Style style) throws IOException {
        boolean showHeader;
        Measure sheetHeight;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String sheetId = sheet.getClientId(facesContext);
        if (style.getHeight() == null) {
            LOG.error("no height in parent container, setting to 100");
            sheetHeight = Measure.valueOf((int)100);
        } else {
            sheetHeight = style.getHeight();
        }
        Measure footerHeight = this.getFooterHeight(facesContext, sheet);
        Measure headerHeight = this.getHeaderHeight(facesContext, sheet);
        String selectable = sheet.getSelectable();
        Application application = facesContext.getApplication();
        SheetState state = sheet.getSheetState(facesContext);
        List columnWidths = sheet.getWidthList();
        List<Integer> selectedRows = this.getSelectedRows(sheet, state);
        List renderedColumnList = sheet.getRenderedColumns();
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + WIDTHS_POSTFIX);
        writer.writeNameAttribute(sheetId + WIDTHS_POSTFIX);
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", StringUtils.joinWithSurroundingSeparator((List)columnWidths), false);
        writer.endElement("input");
        RenderUtils.writeScrollPosition(facesContext, writer, (UIComponent)sheet, sheet.getScrollPosition());
        if (!"none".equals(selectable)) {
            writer.startElement("input", null);
            writer.writeIdAttribute(sheetId + SELECTED_POSTFIX);
            writer.writeNameAttribute(sheetId + SELECTED_POSTFIX);
            writer.writeAttribute("type", "hidden", false);
            writer.writeAttribute("value", StringUtils.joinWithSurroundingSeparator(selectedRows), true);
            writer.endElement("input");
        }
        ExpandedState expandedState = null;
        StringBuilder expandedValue = null;
        if (sheet.isTreeModel()) {
            expandedState = sheet.getExpandedState();
            expandedValue = new StringBuilder(",");
        }
        boolean ie6SelectOneFix = (showHeader = sheet.isShowHeader()) && ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie6() && ComponentUtils.findDescendant((UIComponent)sheet, UISelectOne.class) != null;
        Style bodyStyle = new Style();
        Measure tableBodyWidth = sheet.getCurrentWidth().subtractNotNegative(this.getContentBorder(facesContext, sheet));
        bodyStyle.setWidth(tableBodyWidth);
        if (sheet.isPagingVisible()) {
            sheetHeight = sheetHeight.subtract(footerHeight);
        }
        if (ie6SelectOneFix) {
            bodyStyle.setTop(headerHeight);
        }
        if (showHeader) {
            sheetHeight = sheetHeight.subtract(headerHeight);
        }
        bodyStyle.setHeight(sheetHeight);
        if (showHeader) {
            this.renderColumnHeaders(facesContext, sheet, writer, renderedColumnList);
        }
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "::" + "data_div");
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"body"));
        writer.writeStyleAttribute(bodyStyle);
        Style sheetBodyStyle = new Style(bodyStyle);
        sheetBodyStyle.setHeight(null);
        sheetBodyStyle.setTop(null);
        boolean needVerticalScrollbar = this.needVerticalScrollbar(facesContext, sheet);
        if (needVerticalScrollbar) {
            tableBodyWidth = tableBodyWidth.subtractNotNegative(this.getVerticalScrollbarWeight(facesContext, (Configurable)sheet));
        }
        ArrayList<Integer> dataWidths = null;
        if (columnWidths != null) {
            dataWidths = new ArrayList<Integer>(columnWidths);
            int usedWidth = 0;
            int dataWidthsSize = dataWidths.size();
            for (int i = 0; i < dataWidthsSize - 1; ++i) {
                usedWidth += ((Integer)dataWidths.get(i)).intValue();
            }
            if (usedWidth < tableBodyWidth.getPixel()) {
                dataWidths.set(dataWidths.size() - 1, tableBodyWidth.getPixel() - usedWidth);
                sheetBodyStyle.setWidth(tableBodyWidth);
            } else {
                dataWidths.set(dataWidths.size() - 1, 0);
                sheetBodyStyle.setWidth(Measure.valueOf((int)usedWidth));
            }
        } else {
            sheetBodyStyle.setWidth(tableBodyWidth);
        }
        writer.startElement("table", null);
        writer.writeAttribute("cellspacing", "0", false);
        writer.writeAttribute("cellpadding", "0", false);
        writer.writeAttribute("summary", "", false);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"bodyTable"));
        writer.writeStyleAttribute(sheetBodyStyle);
        if (dataWidths != null) {
            writer.startElement("colgroup", null);
            for (Integer columnWidth : dataWidths) {
                writer.startElement("col", null);
                writer.writeAttribute("width", columnWidth.intValue());
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("first = " + sheet.getFirst() + "   rows = " + sheet.getRows());
        }
        String var = sheet.getVar();
        boolean odd = false;
        boolean emptySheet = true;
        int last = sheet.isRowsUnlimited() ? Integer.MAX_VALUE : sheet.getFirst() + sheet.getRows();
        for (int rowIndex = sheet.getFirst(); rowIndex < last; ++rowIndex) {
            String parentId;
            String[] rowMarkups;
            sheet.setRowIndex(rowIndex);
            if (!sheet.isRowAvailable()) break;
            Object rowRendered = sheet.getAttributes().get("rowRendered");
            if (rowRendered instanceof Boolean && !((Boolean)rowRendered).booleanValue()) continue;
            emptySheet = false;
            boolean bl = odd = !odd;
            if (LOG.isDebugEnabled()) {
                LOG.debug("var       " + var);
                LOG.debug("list      " + sheet.getValue());
            }
            if (sheet.isTreeModel()) {
                TreePath path = sheet.getPath();
                if (sheet.isFolder() && expandedState.isExpanded(path)) {
                    expandedValue.append(rowIndex);
                    expandedValue.append(",");
                }
            }
            writer.startElement("tr", null);
            if (rowRendered instanceof Boolean) {
                writer.writeAttribute("data-tobago-row-index", rowIndex);
            }
            Markup rowMarkup = odd ? Markup.ODD : Markup.EVEN;
            boolean selected = selectedRows.contains(rowIndex);
            if (selected) {
                rowMarkup = rowMarkup.add(Markup.SELECTED);
            }
            if ((rowMarkups = (String[])sheet.getAttributes().get("rowMarkup")) != null) {
                rowMarkup = rowMarkup.add(Markup.valueOf((String[])rowMarkups));
            }
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"row", (Markup)rowMarkup));
            if (!sheet.isRowVisible()) {
                Style rowStyle = new Style();
                rowStyle.setDisplay(Display.NONE);
                writer.writeStyleAttribute(rowStyle);
            }
            if ((parentId = sheet.getRowParentClientId()) != null) {
                writer.writeAttribute("data-tobago-tree-parent", parentId, false);
            }
            int columnIndex = -1;
            for (UIColumn column : renderedColumnList) {
                Markup markup;
                ++columnIndex;
                writer.startElement("td", (UIComponent)column);
                Markup markup2 = markup = column instanceof SupportsMarkup ? ((SupportsMarkup)column).getMarkup() : Markup.NULL;
                if (markup == null) {
                    markup = Markup.NULL;
                }
                if (columnIndex == 0) {
                    markup = markup.add(Markup.FIRST);
                }
                if (hasClickAction) {
                    markup = markup.add(Markup.CLICKABLE);
                }
                if (this.isPure(column)) {
                    markup = markup.add(Markup.PURE);
                }
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"cell", (Markup)markup));
                TextAlign align = TextAlign.parse((String)((String)column.getAttributes().get("align")));
                if (align != null) {
                    Style alignStyle = new Style();
                    alignStyle.setTextAlign(align);
                    writer.writeStyleAttribute(alignStyle);
                }
                if (column instanceof UIColumnSelector) {
                    boolean disabled = ComponentUtils.getBooleanAttribute((UIComponent)column, (String)"disabled");
                    writer.startElement("input", null);
                    writer.writeAttribute("type", "checkbox", false);
                    writer.writeAttribute("checked", selected);
                    writer.writeAttribute("disabled", disabled);
                    writer.writeIdAttribute(sheetId + "_data_row_selector_" + rowIndex);
                    writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"columnSelector"));
                    writer.endElement("input");
                } else if (column instanceof AbstractUIColumnNode) {
                    EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)column);
                    RenderUtils.encode(facesContext, (UIComponent)column);
                } else {
                    List children = sheet.getRenderedChildrenOf(column);
                    for (UIComponent grandKid : children) {
                        grandKid.getAttributes().put("layoutHeight", HEIGHT_0);
                        if (grandKid instanceof LayoutBase) {
                            LayoutBase base = (LayoutBase)grandKid;
                            if (base.getLeft() != null) {
                                base.setLeft(null);
                            }
                            if (base.getTop() != null) {
                                base.setTop(null);
                            }
                        }
                        EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)grandKid);
                        RenderUtils.encode(facesContext, grandKid);
                    }
                }
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"cell", (Markup)Markup.FILLER));
            writer.startElement("div", null);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        sheet.setRowIndex(-1);
        if (emptySheet && showHeader) {
            writer.startElement("tr", null);
            int columnIndex = -1;
            for (UIColumn ignored : renderedColumnList) {
                writer.startElement("td", null);
                writer.startElement("div", null);
                Integer divWidth = sheet.getWidthList() != null ? (Integer)sheet.getWidthList().get(++columnIndex) : 100;
                Style divStyle = new Style();
                divStyle.setWidth(Measure.valueOf((Integer)divWidth));
                writer.writeStyleAttribute(divStyle);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"cell", (Markup)Markup.FILLER));
            writer.startElement("div", null);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
        writer.endElement("div");
        if (sheet.isPagingVisible()) {
            Markup showPageRange;
            Markup showDirectLinks;
            Style footerStyle = new Style();
            footerStyle.setWidth(sheet.getCurrentWidth());
            if (ie6SelectOneFix) {
                footerStyle.setTop(headerHeight);
            }
            writer.startElement("div", (UIComponent)sheet);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"footer"));
            writer.writeStyleAttribute(footerStyle);
            Markup showRowRange = this.markupForLeftCenterRight(sheet.getShowRowRange());
            if (showRowRange != Markup.NULL) {
                UICommand pagerCommand = (UICommand)sheet.getFacet("pagerRow");
                if (pagerCommand == null) {
                    pagerCommand = this.createPagingCommand(application, PageAction.TO_ROW, false);
                    sheet.getFacets().put("pagerRow", pagerCommand);
                }
                String pagerCommandId = pagerCommand.getClientId(facesContext);
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingOuter", (Markup)showRowRange));
                writer.writeAttribute("title", ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoRowPagingTip"), true);
                writer.flush();
                writer.write(this.createSheetPagingInfo(sheet, facesContext, pagerCommandId, true));
                writer.endElement("span");
            }
            if ((showDirectLinks = this.markupForLeftCenterRight(sheet.getShowDirectLinks())) != Markup.NULL) {
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingOuter", (Markup)showDirectLinks));
                String areaId = "pagingLinks";
                writer.writeIdAttribute(sheetId + "::" + areaId);
                if (sheet.isShowDirectLinksArrows()) {
                    boolean atBeginning = sheet.isAtBeginning();
                    this.link(facesContext, application, areaId, atBeginning, PageAction.FIRST, sheet);
                    this.link(facesContext, application, areaId, atBeginning, PageAction.PREV, sheet);
                }
                this.writeDirectPagingLinks(writer, facesContext, application, sheet);
                if (sheet.isShowDirectLinksArrows()) {
                    boolean atEnd = sheet.isAtEnd();
                    this.link(facesContext, application, areaId, atEnd, PageAction.NEXT, sheet);
                    this.link(facesContext, application, areaId, atEnd || !sheet.hasRowCount(), PageAction.LAST, sheet);
                }
                writer.endElement("span");
            }
            if ((showPageRange = this.markupForLeftCenterRight(sheet.getShowPageRange())) != Markup.NULL) {
                UICommand pagerCommand = (UICommand)sheet.getFacet("pagerPage");
                if (pagerCommand == null) {
                    pagerCommand = this.createPagingCommand(application, PageAction.TO_PAGE, false);
                    sheet.getFacets().put("pagerPage", pagerCommand);
                }
                String pagerCommandId = pagerCommand.getClientId(facesContext);
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingOuter", (Markup)showPageRange));
                String areaId = "pagingPages";
                writer.writeIdAttribute(sheetId + "::" + areaId);
                writer.writeText("");
                if (sheet.isShowPageRangeArrows()) {
                    boolean atBeginning = sheet.isAtBeginning();
                    this.link(facesContext, application, areaId, atBeginning, PageAction.FIRST, sheet);
                    this.link(facesContext, application, areaId, atBeginning, PageAction.PREV, sheet);
                }
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingText"));
                writer.writeAttribute("title", ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoPagePagingTip"), true);
                writer.flush();
                writer.write(this.createSheetPagingInfo(sheet, facesContext, pagerCommandId, false));
                writer.endElement("span");
                if (sheet.isShowPageRangeArrows()) {
                    boolean atEnd = sheet.isAtEnd();
                    this.link(facesContext, application, areaId, atEnd, PageAction.NEXT, sheet);
                    this.link(facesContext, application, areaId, atEnd || !sheet.hasRowCount(), PageAction.LAST, sheet);
                }
                writer.endElement("span");
            }
            writer.endElement("div");
        }
        if (sheet.isTreeModel()) {
            writer.startElement("input", (UIComponent)sheet);
            writer.writeAttribute("type", "hidden", false);
            String expandedId = sheetId + "::" + "expanded";
            writer.writeNameAttribute(expandedId);
            writer.writeIdAttribute(expandedId);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"expanded"));
            writer.writeAttribute("value", expandedValue.toString(), false);
            writer.endElement("input");
        }
    }

    private boolean isPure(UIColumn column) {
        for (UIComponent child : column.getChildren()) {
            if (child instanceof UIOut || child instanceof UILink) continue;
            return true;
        }
        return false;
    }

    private String createSheetPagingInfo(UISheet sheet, FacesContext facesContext, String pagerCommandId, boolean row) {
        String sheetPagingInfo;
        if (sheet.getRowCount() != 0) {
            int first;
            Locale locale = facesContext.getViewRoot().getLocale();
            int n = first = row ? sheet.getFirst() + 1 : sheet.getCurrentPage() + 1;
            int last = sheet.hasRowCount() ? (row ? sheet.getLastRowIndexOfCurrentPage() : sheet.getPages()) : -1;
            boolean unknown = !sheet.hasRowCount();
            String key = "sheetPagingInfo" + (unknown ? "Undefined" : "") + (first == last ? "Single" : "") + (row ? "Row" : "Page") + (first == last ? "" : "s");
            String message = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)key);
            MessageFormat detail = new MessageFormat(message, locale);
            Object[] args = new Object[]{first, last == -1 ? "?" : Integer.valueOf(last), unknown ? "" : Integer.valueOf(sheet.getRowCount()), pagerCommandId + "::" + "text"};
            sheetPagingInfo = detail.format(args);
        } else {
            sheetPagingInfo = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheetPagingInfoEmpty" + (row ? "Row" : "Page")));
        }
        return sheetPagingInfo;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        String widths;
        super.decode(facesContext, component);
        UISheet sheet = (UISheet)component;
        String key = sheet.getClientId(facesContext) + WIDTHS_POSTFIX;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(key) && (widths = (String)requestParameterMap.get(key)).trim().length() > 0) {
            sheet.getAttributes().put("widthListString", widths);
        }
        if (requestParameterMap.containsKey(key = sheet.getClientId(facesContext) + SELECTED_POSTFIX)) {
            List selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected = " + selected);
            }
            try {
                selectedRows = StringUtils.parseIntegerList((String)selected);
            }
            catch (NumberFormatException e) {
                LOG.warn(selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            sheet.getAttributes().put("selectedListString", selectedRows);
        }
        RenderUtils.decodeScrollPosition(facesContext, (UIComponent)sheet);
        RenderUtils.decodedStateOfTreeData(facesContext, (AbstractUIData)sheet);
    }

    private Measure getHeaderHeight(FacesContext facesContext, UISheet sheet) {
        int rows = sheet.getHeaderGrid() != null ? sheet.getHeaderGrid().getRowCount() : 0;
        return sheet.isShowHeader() ? this.getResourceManager().getThemeMeasure(facesContext, (Configurable)sheet, "headerHeight").multiply(rows) : Measure.ZERO;
    }

    private Measure getRowHeight(FacesContext facesContext, UISheet sheet) {
        return this.getResourceManager().getThemeMeasure(facesContext, (Configurable)sheet, "rowHeight");
    }

    private Measure getFooterHeight(FacesContext facesContext, UISheet sheet) {
        return sheet.isPagingVisible() ? this.getResourceManager().getThemeMeasure(facesContext, (Configurable)sheet, "footerHeight") : Measure.ZERO;
    }

    private Markup markupForLeftCenterRight(String name) {
        if ("left".equals(name)) {
            return Markup.LEFT;
        }
        if ("center".equals(name)) {
            return Markup.CENTER;
        }
        if ("right".equals(name)) {
            return Markup.RIGHT;
        }
        return Markup.NULL;
    }

    private String checkPagingAttribute(String name) {
        if (this.isNotNone(name)) {
            return name;
        }
        if (!"none".equals(name)) {
            LOG.warn("Illegal value in sheets paging attribute: '" + name + "'");
        }
        return "none";
    }

    private boolean isNotNone(String value) {
        return "left".equals(value) || "center".equals(value) || "right".equals(value);
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(UISheet data, SheetState state) {
        List selected = (List)data.getAttributes().get("selectedListString");
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private void link(FacesContext facesContext, Application application, String areaId, boolean disabled, PageAction command, UISheet data) throws IOException {
        UICommand link = this.createPagingCommand(application, command, disabled);
        data.getFacets().put(command.getToken(), link);
        String tip = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheet" + command.getToken()));
        String image = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)("image/sheet" + command.getToken() + (disabled ? "Disabled" : "")));
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("img", null);
        writer.writeIdAttribute(data.getClientId(facesContext) + "::" + areaId + "::" + "pagingArrows" + "::" + command.getToken());
        Classes pagerClasses = Classes.create((UIComponent)data, (String)"footerPagerButton", (Markup)(disabled ? Markup.DISABLED : null));
        writer.writeClassAttribute(pagerClasses);
        writer.writeAttribute("src", image, false);
        writer.writeAttribute("title", tip, true);
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("data-tobago-disabled", disabled);
        writer.endElement("img");
    }

    private void renderColumnHeaders(FacesContext facesContext, UISheet sheet, TobagoResponseWriter writer, List<AbstractUIColumn> renderedColumnList) throws IOException {
        int i;
        Grid grid = sheet.getHeaderGrid();
        if (grid == null) {
            LOG.warn("Can't render column headers, because grid == null. One reason can be, the you use nested sheets. The inner sheet ensureHeader() will be called outside the iterating over the rows. Nesting sheet is currently not supported.");
            return;
        }
        List columnWidths = sheet.getWidthList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("*****************************************************");
            LOG.debug("" + grid);
            LOG.debug("*****************************************************");
        }
        boolean needVerticalScrollbar = this.needVerticalScrollbar(facesContext, sheet);
        int verticalScrollbarWidth = 0;
        writer.startElement("div", (UIComponent)sheet);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerDiv"));
        writer.startElement("table", (UIComponent)sheet);
        writer.writeAttribute("cellspacing", "0", false);
        writer.writeAttribute("cellpadding", "0", false);
        writer.writeAttribute("summary", "", false);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerTable"));
        if (needVerticalScrollbar) {
            verticalScrollbarWidth = this.getVerticalScrollbarWeight(facesContext, (Configurable)sheet).getPixel();
            writer.writeAttribute("data-tobago-sheet-verticalscrollbarwidth", String.valueOf(verticalScrollbarWidth), false);
        }
        if (columnWidths != null) {
            writer.startElement("colgroup", null);
            for (i = 0; i < columnWidths.size(); ++i) {
                writer.startElement("col", null);
                writer.writeAttribute("width", ((Integer)columnWidths.get(i)).intValue());
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        writer.startElement("tbody", (UIComponent)sheet);
        for (i = 0; i < grid.getRowCount(); ++i) {
            writer.startElement("tr", null);
            for (int j = 0; j < grid.getColumnCount(); ++j) {
                boolean sortable;
                UIComponent cellComponent;
                Cell cell = grid.getCell(j, i);
                if (!(cell instanceof OriginCell)) continue;
                writer.startElement("td", null);
                if (cell.getColumnSpan() > 1) {
                    writer.writeAttribute("colspan", cell.getColumnSpan());
                }
                if (cell.getRowSpan() > 1) {
                    writer.writeAttribute("rowspan", cell.getRowSpan());
                }
                boolean pure = !((cellComponent = (UIComponent)cell.getComponent()) instanceof UIOut);
                writer.startElement("div", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerCell"));
                writer.startElement("span", null);
                Style headerStyle = new Style();
                Measure headerHeight = Measure.valueOf((int)20).multiply(cell.getRowSpan());
                if (!pure) {
                    headerHeight = headerHeight.subtract(6);
                }
                headerStyle.setHeight(headerHeight);
                writer.writeStyleAttribute(headerStyle);
                AbstractUIColumn column = renderedColumnList.get(j);
                String sorterImage = null;
                Markup markup = Markup.NULL;
                String tip = (String)column.getAttributes().get("tip");
                if (cell.getColumnSpan() == 1 && cellComponent instanceof UIOut && (sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, (String)"sortable"))) {
                    String[] clientIds;
                    UICommand sortCommand = (UICommand)column.getFacet("sorter");
                    if (sortCommand == null) {
                        String columnId = column.getClientId(facesContext);
                        String sorterId = columnId.substring(columnId.lastIndexOf(":") + 1) + "_" + "sorter";
                        sortCommand = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", (String)"Link", (String)sorterId);
                        column.getFacets().put("sorter", sortCommand);
                    }
                    if ((clientIds = ComponentUtils.evaluateClientIds((FacesContext)facesContext, (UIComponent)sheet, (String[])sheet.getRenderedPartially())).length == 0) {
                        clientIds = new String[]{sheet.getClientId(facesContext)};
                    }
                    CommandMap map = new CommandMap();
                    Command click = new Command(sortCommand.getClientId(facesContext), null, null, null, clientIds, null, null, null, null, null);
                    map.setClick(click);
                    writer.writeAttribute("data-tobago-commands", JsonUtils.encode(map), true);
                    tip = tip == null ? "" : tip + " - ";
                    tip = tip + ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetTipSorting");
                    markup = markup.add(Markup.SORTABLE);
                    SheetState sheetState = sheet.getSheetState(facesContext);
                    if (column.getId().equals(sheetState.getSortedColumnId())) {
                        String sortTitle;
                        if (sheetState.isAscending()) {
                            sorterImage = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/ascending");
                            sortTitle = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetAscending");
                            markup = markup.add(Markup.ASCENDING);
                        } else {
                            sorterImage = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/descending");
                            sortTitle = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetDescending");
                            markup = markup.add(Markup.DESCENDING);
                        }
                        if (sortTitle != null) {
                            tip = tip + " - " + sortTitle;
                        }
                    }
                }
                if (j == 0) {
                    markup = markup.add(Markup.FIRST);
                }
                if (pure) {
                    markup = markup.add(Markup.PURE);
                }
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"header", (Markup)markup));
                writer.writeAttribute("title", tip, true);
                if (column instanceof UIColumnSelector) {
                    this.renderColumnSelectorHeader(facesContext, writer, sheet);
                } else {
                    RenderUtils.encode(facesContext, cellComponent);
                    AbstractUIMenu dropDownMenu = FacetUtils.getDropDownMenu((UIComponent)column);
                    if (dropDownMenu != null && dropDownMenu.isRendered()) {
                        writer.startElement("span", (UIComponent)column);
                        writer.writeClassAttribute(Classes.create((UIComponent)column, (String)"menu"));
                        writer.startElement("img", (UIComponent)column);
                        String menuImage = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/sheetSelectorMenu");
                        writer.writeAttribute("title", "", false);
                        writer.writeAttribute("src", menuImage, false);
                        writer.endElement("img");
                        ToolBarRendererBase.renderDropDownMenu(facesContext, writer, dropDownMenu);
                        writer.endElement("span");
                    }
                }
                if (sorterImage != null) {
                    writer.startElement("img", null);
                    writer.writeAttribute("src", sorterImage, false);
                    writer.writeAttribute("alt", "", false);
                    writer.endElement("img");
                }
                writer.endElement("span");
                if (renderedColumnList.get(j).isResizable()) {
                    this.encodeResizing(writer, (AbstractUISheet)sheet, j + cell.getColumnSpan() - 1);
                }
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerCell", (Markup)Markup.FILLER));
            writer.startElement("span", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"header"));
            Style headerStyle = new Style();
            headerStyle.setHeight(Measure.valueOf((int)14));
            writer.writeStyleAttribute(headerStyle);
            writer.endElement("span");
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    private boolean needVerticalScrollbar(FacesContext facesContext, UISheet sheet) {
        LayoutManager layoutManager = sheet.getLayoutManager();
        if (layoutManager instanceof AbstractUISheetLayout) {
            return ((AbstractUISheetLayout)layoutManager).needVerticalScrollbar(facesContext, (AbstractUISheet)sheet);
        }
        LOG.error("Sheet must use a sheet layout, but found: " + layoutManager.getClass().getName());
        return true;
    }

    private void encodeResizing(TobagoResponseWriter writer, AbstractUISheet sheet, int columnIndex) throws IOException {
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerResize"));
        writer.writeAttribute("data-tobago-column-index", Integer.toString(columnIndex), false);
        writer.write("&nbsp;&nbsp;");
        writer.endElement("span");
    }

    protected void renderColumnSelectorHeader(FacesContext facesContext, TobagoResponseWriter writer, UISheet sheet) throws IOException {
        UIToolBar toolBar = this.createToolBar(facesContext, sheet);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"toolBar"));
        if ("multi".equals(sheet.getSelectable())) {
            EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)toolBar);
            RenderUtils.encode(facesContext, (UIComponent)toolBar);
        }
        writer.endElement("div");
    }

    private UIToolBar createToolBar(FacesContext facesContext, UISheet sheet) {
        Application application = facesContext.getApplication();
        UICommand dropDown = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", null, (String)"dropDown");
        dropDown.setOmit(true);
        UIMenu menu = (UIMenu)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Menu", (String)"Menu", (String)"menu");
        FacetUtils.setDropDownMenu((UIComponent)dropDown, (AbstractUIMenu)menu);
        String sheetId = sheet.getClientId(facesContext);
        this.createMenuItem(facesContext, menu, "sheetMenuSelect", Markup.SHEET_SELECT_ALL, sheetId);
        this.createMenuItem(facesContext, menu, "sheetMenuUnselect", Markup.SHEET_DESELECT_ALL, sheetId);
        this.createMenuItem(facesContext, menu, "sheetMenuToggleselect", Markup.SHEET_TOGGLE_ALL, sheetId);
        UIToolBar toolBar = (UIToolBar)application.createComponent("org.apache.myfaces.tobago.ToolBar");
        toolBar.setId(facesContext.getViewRoot().createUniqueId());
        toolBar.setRendererType("TabGroupToolBar");
        toolBar.setTransient(true);
        toolBar.getChildren().add(dropDown);
        sheet.getFacets().put("toolBar", toolBar);
        return toolBar;
    }

    private void createMenuItem(FacesContext facesContext, UIMenu menu, String label, Markup markup, String sheetId) {
        String id = markup.toString();
        UIMenuCommand menuItem = (UIMenuCommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.MenuCommand", (String)"MenuCommand", (String)id);
        menuItem.setLabel(ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)label));
        menuItem.setMarkup(markup);
        menuItem.setOmit(true);
        ComponentUtils.putDataAttributeWithPrefix((UIComponent)menuItem, (String)"data-tobago-sheet-id", (Object)sheetId);
        menu.getChildren().add(menuItem);
    }

    private void writeDirectPagingLinks(TobagoResponseWriter writer, FacesContext facesContext, Application application, UISheet sheet) throws IOException {
        int skip;
        UICommand pagerCommand = (UICommand)sheet.getFacet("pagerPage");
        if (pagerCommand == null) {
            pagerCommand = this.createPagingCommand(application, PageAction.TO_PAGE, false);
            sheet.getFacets().put("pagerPage", pagerCommand);
        }
        String pagerCommandId = pagerCommand.getClientId(facesContext);
        int linkCount = ComponentUtils.getIntAttribute((UIComponent)sheet, (String)"directLinkCount");
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = sheet.getCurrentPage() + 1;
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, page);
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = sheet.getCurrentPage() + 1;
        int pages = sheet.hasRowCount() || sheet.isRowsUnlimited() ? sheet.getPages() : Integer.MAX_VALUE;
        for (int i = 0; i < linkCount && page < pages; ++i) {
            if (++page <= 1) continue;
            nexts.add(page);
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (!sheet.isShowDirectLinksArrows() && skip > 1) {
            skip -= linkCount - linkCount / 2;
            String name = DOTS;
            if (--skip < 1) {
                skip = 1;
                if ((Integer)prevs.get(0) == 2) {
                    name = "1";
                }
            }
            this.writeLinkElement(writer, sheet, name, Integer.toString(skip), pagerCommandId, true);
        }
        for (Integer prev : prevs) {
            String name = prev.toString();
            this.writeLinkElement(writer, sheet, name, name, pagerCommandId, true);
        }
        String name = Integer.toString(sheet.getCurrentPage() + 1);
        this.writeLinkElement(writer, sheet, name, name, pagerCommandId, false);
        for (Integer next : nexts) {
            name = next.toString();
            this.writeLinkElement(writer, sheet, name, name, pagerCommandId, true);
        }
        int n2 = skip = nexts.size() > 0 ? (Integer)nexts.get(nexts.size() - 1) : pages;
        if (!sheet.isShowDirectLinksArrows() && skip < pages) {
            skip += linkCount / 2;
            name = DOTS;
            if (++skip > pages) {
                skip = pages;
                if ((Integer)nexts.get(nexts.size() - 1) == skip - 1) {
                    name = Integer.toString(skip);
                }
            }
            this.writeLinkElement(writer, sheet, name, Integer.toString(skip), pagerCommandId, true);
        }
    }

    private UICommand createPagingCommand(Application application, PageAction command, boolean disabled) {
        UICommand link = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        link.setRendererType("SheetPageCommand");
        link.setRendered(true);
        link.setId(command.getToken());
        link.getAttributes().put("inline", Boolean.TRUE);
        link.getAttributes().put("disabled", disabled);
        return link;
    }

    private void writeLinkElement(TobagoResponseWriter writer, UISheet sheet, String str, String skip, String id, boolean makeLink) throws IOException {
        String type = makeLink ? "a" : "span";
        writer.startElement(type, null);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingLink"));
        if (makeLink) {
            writer.writeIdAttribute(id + "::" + "link_" + skip);
            writer.writeAttribute("href", "#", false);
        }
        writer.flush();
        writer.write(str);
        writer.endElement(type);
    }

    private Measure getContentBorder(FacesContext facesContext, UISheet data) {
        return this.getBorderLeft(facesContext, (Configurable)data).add(this.getBorderRight(facesContext, (Configurable)data));
    }

    public Measure getPreferredHeight(FacesContext facesContext, Configurable component) {
        UISheet sheet = (UISheet)component;
        Measure headerHeight = this.getHeaderHeight(facesContext, sheet);
        Measure rowHeight = this.getRowHeight(facesContext, sheet);
        Measure footerHeight = this.getFooterHeight(facesContext, sheet);
        int rows = sheet.getRows();
        if (rows == 0) {
            rows = sheet.getRowCount();
        }
        if (rows == -1) {
            rows = 10;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(headerHeight + " " + footerHeight + " " + rowHeight + " " + rows);
        }
        return headerHeight.add(rowHeight.multiply(rows)).add(footerHeight);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getPrepareRendersChildren() {
        return true;
    }

    public void prepareRendersChildren(FacesContext facesContext, UIComponent component) throws IOException {
        UISheet sheet = (UISheet)component;
        for (UIColumn column : sheet.getRenderedColumns()) {
            if (column instanceof AbstractUIColumnNode) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("TODO: AbstractUIColumnNode are not prepared.");
                continue;
            }
            EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)column);
        }
    }
}

