/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIIn;
import org.apache.myfaces.tobago.component.UISuggest;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.model.AutoSuggestItem;
import org.apache.myfaces.tobago.model.AutoSuggestItems;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SuggestRenderer
extends InputRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISuggest suggest = (UISuggest)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String id = suggest.getClientId(facesContext);
        UIIn in = (UIIn)suggest.getParent();
        MethodExpression suggestMethodExpression = suggest.getSuggestMethodExpression();
        AutoSuggestItems items = this.createAutoSuggestItems(suggestMethodExpression.invoke(facesContext.getELContext(), new Object[]{in}));
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)suggest));
        writer.writeIdAttribute(id);
        writer.writeAttribute("data-tobago-for", in.getClientId(facesContext), false);
        writer.writeAttribute("data-tobago-suggest-min-chars", suggest.getMinimumCharacters().intValue());
        writer.writeAttribute("data-tobago-suggest-delay", suggest.getDelay().intValue());
        writer.writeAttribute("data-tobago-suggest-max-items", suggest.getMaximumItems().intValue());
        writer.writeAttribute("data-tobago-suggest-update", Boolean.toString(suggest.isUpdate()), false);
        int totalCount = suggest.getTotalCount();
        if (totalCount == -1) {
            totalCount = items.getItems().size();
        }
        writer.writeAttribute("data-tobago-suggest-total-count", totalCount);
        writer.startElement("ol", null);
        writer.writeClassAttribute("tobago-menuBar");
        writer.startElement("li", null);
        writer.writeClassAttribute("tobago-menu tobago-menu-markup-top");
        writer.startElement("a", null);
        writer.writeAttribute("href", "#", false);
        writer.writeAttribute("tabindex", -1);
        writer.endElement("a");
        writer.startElement("ol", null);
        for (AutoSuggestItem item : items.getItems()) {
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", "#", false);
            writer.writeText(item.getLabel());
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.startElement("li", null);
        writer.writeAttribute("disabled", true);
        String title = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.in.inputSuggest.moreElements");
        writer.writeAttribute("title", title, true);
        writer.startElement("a", null);
        writer.writeAttribute("href", "#", false);
        writer.writeText("...");
        writer.endElement("a");
        writer.endElement("li");
        writer.endElement("ol");
        writer.endElement("li");
        writer.endElement("ol");
        writer.endElement("div");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AutoSuggestItems createAutoSuggestItems(Object object) {
        if (object instanceof AutoSuggestItems) {
            return (AutoSuggestItems)object;
        }
        AutoSuggestItems autoSuggestItems = new AutoSuggestItems();
        if (object instanceof List && !((List)object).isEmpty()) {
            if (((List)object).get(0) instanceof AutoSuggestItem) {
                autoSuggestItems.setItems((List)object);
                return autoSuggestItems;
            } else {
                if (!(((List)object).get(0) instanceof String)) throw new ClassCastException("Can't create AutoSuggestItems from '" + object + "'. " + "Elements needs to be " + String.class.getName() + " or " + AutoSuggestItem.class.getName());
                ArrayList<AutoSuggestItem> items = new ArrayList<AutoSuggestItem>(((List)object).size());
                for (int i = 0; i < ((List)object).size(); ++i) {
                    AutoSuggestItem item = new AutoSuggestItem();
                    item.setLabel((String)((List)object).get(i));
                    item.setValue((String)((List)object).get(i));
                    items.add(item);
                }
                autoSuggestItems.setItems(items);
            }
            return autoSuggestItems;
        } else {
            autoSuggestItems.setItems(Collections.emptyList());
        }
        return autoSuggestItems;
    }
}

