/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.date;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import org.apache.myfaces.custom.calendar.DateBusinessConverter;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.custom.date.AbstractHtmlInputDate.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlInputDate extends org.apache.myfaces.custom.date.AbstractHtmlInputDate
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Input";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlInputDate";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.Date";


    public HtmlInputDate()
    {
        setRendererType("org.apache.myfaces.Date");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: dateBusinessConverter
    public DateBusinessConverter getDateBusinessConverter()
    {
        return (DateBusinessConverter) getStateHelper().eval(PropertyKeys.dateBusinessConverter);
    }
    
    public void setDateBusinessConverter(DateBusinessConverter dateBusinessConverter)
    {
        getStateHelper().put(PropertyKeys.dateBusinessConverter, dateBusinessConverter ); 
    }    
    // Property: timeZone
    public String getTimeZone()
    {
        return (String) getStateHelper().eval(PropertyKeys.timeZone);
    }
    
    public void setTimeZone(String timeZone)
    {
        getStateHelper().put(PropertyKeys.timeZone, timeZone ); 
    }    
    // Property: type
    public String getType()
    {
        return (String) getStateHelper().eval(PropertyKeys.type, "date");
    }
    
    public void setType(String type)
    {
        getStateHelper().put(PropertyKeys.type, type ); 
    }    
    // Property: ampm
    public boolean isAmpm()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.ampm, false);
    }
    
    public void setAmpm(boolean ampm)
    {
        getStateHelper().put(PropertyKeys.ampm, ampm ); 
    }    
    // Property: popupCalendar
    public boolean isPopupCalendar()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.popupCalendar, false);
    }
    
    public void setPopupCalendar(boolean popupCalendar)
    {
        getStateHelper().put(PropertyKeys.popupCalendar, popupCalendar ); 
    }    
    // Property: emptyMonthSelection
    public String getEmptyMonthSelection()
    {
        return (String) getStateHelper().eval(PropertyKeys.emptyMonthSelection, "");
    }
    
    public void setEmptyMonthSelection(String emptyMonthSelection)
    {
        getStateHelper().put(PropertyKeys.emptyMonthSelection, emptyMonthSelection ); 
    }    
    // Property: emptyAmpmSelection
    public String getEmptyAmpmSelection()
    {
        return (String) getStateHelper().eval(PropertyKeys.emptyAmpmSelection, "");
    }
    
    public void setEmptyAmpmSelection(String emptyAmpmSelection)
    {
        getStateHelper().put(PropertyKeys.emptyAmpmSelection, emptyAmpmSelection ); 
    }    
    // Property: readonly
    public boolean isReadonly()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.readonly, false);
    }
    
    public void setReadonly(boolean readonly)
    {
        getStateHelper().put(PropertyKeys.readonly, readonly ); 
    }    
    // Property: disabled
    public boolean isDisabled()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.disabled, false);
    }
    
    public void setDisabled(boolean disabled)
    {
        getStateHelper().put(PropertyKeys.disabled, disabled ); 
    }    
    // Property: align
    public String getAlign()
    {
        return (String) getStateHelper().eval(PropertyKeys.align);
    }
    
    public void setAlign(String align)
    {
        getStateHelper().put(PropertyKeys.align, align ); 
    }    
    // Property: enabledOnUserRole
    public String getEnabledOnUserRole()
    {
        return (String) getStateHelper().eval(PropertyKeys.enabledOnUserRole);
    }
    
    public void setEnabledOnUserRole(String enabledOnUserRole)
    {
        getStateHelper().put(PropertyKeys.enabledOnUserRole, enabledOnUserRole ); 
    }    
    // Property: visibleOnUserRole
    public String getVisibleOnUserRole()
    {
        return (String) getStateHelper().eval(PropertyKeys.visibleOnUserRole);
    }
    
    public void setVisibleOnUserRole(String visibleOnUserRole)
    {
        getStateHelper().put(PropertyKeys.visibleOnUserRole, visibleOnUserRole ); 
    }    
    // Property: forceId
    public boolean isForceId()
    {
        Object value = getStateHelper().get(PropertyKeys.forceId);
        if (value != null)
        {
            return (Boolean) value;        
        }
        return false;        
    }
    
    public void setForceId(boolean forceId)
    {
        getStateHelper().put(PropertyKeys.forceId, forceId ); 
    }    
    // Property: forceIdIndex
    public boolean isForceIdIndex()
    {
        Object value = getStateHelper().get(PropertyKeys.forceIdIndex);
        if (value != null)
        {
            return (Boolean) value;        
        }
        return true;        
    }
    
    public void setForceIdIndex(boolean forceIdIndex)
    {
        getStateHelper().put(PropertyKeys.forceIdIndex, forceIdIndex ); 
    }    

    protected enum PropertyKeys
    {
         dateBusinessConverter
        , timeZone
        , type
        , ampm
        , popupCalendar
        , emptyMonthSelection
        , emptyAmpmSelection
        , readonly
        , disabled
        , align
        , enabledOnUserRole
        , visibleOnUserRole
        , forceId
        , forceIdIndex
    }

 }
