/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.jslistener;

import java.io.IOException;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.jslistener.JsValueChangeListener;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

@ResourceDependency(library="oam.custom.jslistener", name="JSListener.js")
public class JsValueChangeListenerRenderer
extends HtmlRenderer {
    private static Log log = LogFactory.getLog(JsValueChangeListenerRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, JsValueChangeListener.class);
        UIComponent parent = component.getParent();
        JsValueChangeListener jsValueChangeListener = (JsValueChangeListener)component;
        String aFor = jsValueChangeListener.getFor();
        String expressionValue = jsValueChangeListener.getExpressionValue();
        String property = jsValueChangeListener.getProperty();
        if (aFor != null) {
            UIComponent forComponent = component.findComponent(aFor);
            String forComponentId = null;
            if (forComponent == null) {
                String labelClientId;
                int colon;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Unable to find component '" + aFor + "' (calling findComponent on component '" + component.getClientId(this.getFacesContext()) + "') - will try to render component id based on the parent-id (on same level)"));
                }
                forComponentId = aFor.length() > 0 && aFor.charAt(0) == ':' ? aFor.substring(1) : ((colon = (labelClientId = component.getClientId(this.getFacesContext())).lastIndexOf(58)) == -1 ? aFor : labelClientId.substring(0, colon + 1) + aFor);
            } else {
                forComponentId = forComponent.getClientId(this.getFacesContext());
            }
            expressionValue = expressionValue.replaceAll("\\'", "\\\\'");
            expressionValue = expressionValue.replaceAll("\"", "\\\"");
            String methodCall = "org.apache.myfaces.JSListener.setExpressionProperty('" + parent.getClientId(this.getFacesContext()) + "','" + forComponentId + "'," + (property == null ? "null" : "'" + property + "'") + ",'" + expressionValue + "');";
            this.callMethod(facesContext, jsValueChangeListener, "onchange", methodCall);
            if (jsValueChangeListener.getBodyTagEvent() != null) {
                this.callMethod(facesContext, jsValueChangeListener, jsValueChangeListener.getBodyTagEvent(), methodCall);
            }
        }
    }

    private void callMethod(FacesContext context, JsValueChangeListener jsValueChangeListener, String propName, String value) {
        UIComponent parent = jsValueChangeListener.getParent();
        Object oldValue = parent.getAttributes().get(propName);
        if (oldValue != null) {
            String oldValueStr = oldValue.toString().trim();
            if (oldValueStr.indexOf(parent.getClientId(FacesContext.getCurrentInstance())) < 0 && oldValueStr.length() > 0) {
                oldValueStr = "";
            }
            if (oldValueStr.length() > 0 && !oldValueStr.endsWith(";")) {
                oldValueStr = oldValueStr + ";";
            }
            value = oldValueStr + value;
        }
        if (propName.equals("onchange") || value == null) {
            if (value != null) {
                parent.getAttributes().put(propName, value);
            } else {
                try {
                    parent.getAttributes().remove(propName);
                }
                catch (Exception ex) {
                    log.error((Object)"the value could not be removed : ", (Throwable)ex);
                }
            }
        }
    }

    protected Application getApplication() {
        return this.getFacesContext().getApplication();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

