/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.popup;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.popup.HtmlPopup;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

@ResourceDependency(library="oam.custom.popup", name="JSPopup.js")
public class HtmlPopupRenderer
extends HtmlRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.Popup";
    private static final String LAYOUT_BLOCK = "block";
    private static final String LAYOUT_DIV = "div";
    private static final String LAYOUT_SPAN = "span";
    private static final String LAYOUT_NONE = "none";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlPopup.class);
        HtmlPopup popup = (HtmlPopup)uiComponent;
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        UIComponent popupFacet = popup.getPopup();
        String popupId = this.writePopupScript(facesContext, popup.getClientId(facesContext), popup.getDisplayAtDistanceX(), popup.getDisplayAtDistanceY(), uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        String layout = popup.getLayout();
        if (LAYOUT_BLOCK.equals(layout) || LAYOUT_DIV.equals(layout)) {
            writer.startElement(LAYOUT_DIV, (UIComponent)popup);
            writer.writeAttribute("onmouseover", (Object)(popupId + ".display(event);"), null);
            writer.writeAttribute("onmouseout", (Object)(popupId + ".hide(event);"), null);
        } else if (LAYOUT_NONE.equals(layout)) {
            this.writeMouseOverAttribs(popupId, uiComponent.getChildren(), popup.getClosePopupOnExitingElement() == null || popup.getClosePopupOnExitingElement() != false);
        } else {
            writer.startElement(LAYOUT_SPAN, (UIComponent)popup);
            writer.writeAttribute("onmouseover", (Object)(popupId + ".display(event);"), null);
            writer.writeAttribute("onmouseout", (Object)(popupId + ".hide(event);"), null);
        }
        RendererUtils.renderChildren(facesContext, uiComponent);
        if (LAYOUT_BLOCK.equals(layout) || LAYOUT_DIV.equals(layout)) {
            writer.endElement(LAYOUT_DIV);
        } else if (!LAYOUT_NONE.equals(layout)) {
            writer.endElement(LAYOUT_SPAN);
        }
        writer.startElement(LAYOUT_DIV, (UIComponent)popup);
        writer.writeAttribute("style", (Object)((popup.getStyle() != null ? popup.getStyle() + (popup.getStyle().trim().endsWith(";") ? "" : ";") : "") + "position:absolute;display:none;"), null);
        if (popup.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)popup.getStyleClass(), null);
        }
        writer.writeAttribute("id", (Object)popup.getClientId(facesContext), null);
        if (behaviors != null && !behaviors.isEmpty()) {
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", (UIComponent)popup, "mouseover", null, behaviors, "onmouseover", popup.getOnmouseover(), new String(popupId + ".redisplay();"));
            Boolean closeExitPopup = popup.getClosePopupOnExitingPopup();
            if (closeExitPopup == null || closeExitPopup.booleanValue()) {
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", (UIComponent)popup, "mouseout", null, behaviors, "onmouseout", popup.getOnmouseover(), popupId + ".hide();");
            } else {
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", (UIComponent)popup, "mouseout", null, behaviors, "onmouseout", popup.getOnmouseover(), null);
            }
            HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnmouseoverAndOnmouseout(facesContext, writer, uiComponent, behaviors);
        } else {
            writer.writeAttribute("onmouseover", (Object)new String(popupId + ".redisplay();"), null);
            Boolean closeExitPopup = popup.getClosePopupOnExitingPopup();
            if (closeExitPopup == null || closeExitPopup.booleanValue()) {
                writer.writeAttribute("onmouseout", (Object)(popupId + ".hide();"), null);
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, "onclick", "onclick", (Object)popup.getOnclick());
            HtmlRendererUtils.renderHTMLAttribute(writer, "ondblclick", "ondblclick", (Object)popup.getOndblclick());
            HtmlRendererUtils.renderHTMLAttribute(writer, "onmousedown", "onmousedown", (Object)popup.getOnmousedown());
            HtmlRendererUtils.renderHTMLAttribute(writer, "onmouseup", "onmouseup", (Object)popup.getOnmouseup());
            HtmlRendererUtils.renderHTMLAttribute(writer, "onmousemove", "onmousemove", (Object)popup.getOnmousemove());
            HtmlRendererUtils.renderHTMLAttribute(writer, "onkeypress", "onkeypress", (Object)popup.getOnkeypress());
            HtmlRendererUtils.renderHTMLAttribute(writer, "onkeydown", "onkeydown", (Object)popup.getOnkeydown());
            HtmlRendererUtils.renderHTMLAttribute(writer, "onkeyup", "onkeyup", (Object)popup.getOnkeyup());
        }
        RendererUtils.renderChild(facesContext, popupFacet);
        writer.endElement(LAYOUT_DIV);
    }

    private void writeMouseOverAttribs(String popupId, List children, boolean renderMouseOut) {
        for (int i = 0; i < children.size(); ++i) {
            UIComponent uiComponent = (UIComponent)children.get(i);
            this.callMethod(uiComponent, "onmouseover", popupId + ".display(event);");
            if (renderMouseOut) {
                this.callMethod(uiComponent, "onmouseout", popupId + ".hide(event);");
            }
            this.writeMouseOverAttribs(popupId, uiComponent.getChildren(), renderMouseOut);
        }
    }

    private String writePopupScript(FacesContext context, String clientId, Integer displayAtDistanceX, Integer displayAtDistanceY, UIComponent uiComponent) throws IOException {
        String popupId = JavascriptUtils.getValidJavascriptName(clientId + "Popup", false);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", uiComponent);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("var " + popupId + "=new org.apache.myfaces.Popup('" + clientId + "'," + (displayAtDistanceX == null ? -5 : displayAtDistanceX) + "," + (displayAtDistanceY == null ? -5 : displayAtDistanceY) + ");"), null);
        writer.endElement("script");
        return popupId;
    }

    private void callMethod(UIComponent uiComponent, String propName, String value) {
        Object oldValue = uiComponent.getAttributes().get(propName);
        String oldValueStr = "";
        String genCommentary = "/* generated code */";
        if (oldValue != null) {
            oldValueStr = oldValue.toString().trim();
            int genCommentaryIndex = oldValueStr.indexOf(genCommentary);
            if (genCommentaryIndex != -1) {
                oldValueStr = oldValueStr.substring(0, genCommentaryIndex);
            }
            if (oldValueStr.length() > 0 && !oldValueStr.endsWith(";")) {
                oldValueStr = oldValueStr + ";";
            }
        }
        value = oldValueStr + genCommentary + value;
        uiComponent.getAttributes().put(propName, value);
    }
}

