/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResource2;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.webapp.filter.ExtensionsResponseWrapper;
import org.apache.myfaces.webapp.filter.MultipartRequestWrapper;

public class ExtensionsFilter
implements Filter {
    private Log log = LogFactory.getLog(ExtensionsFilter.class);
    private long _uploadMaxSize = 0x6400000L;
    private long _uploadMaxFileSize = 0x6400000L;
    private int _uploadThresholdSize = 0x100000;
    private String _uploadRepositoryPath = null;
    private boolean _cacheFileSizeErrors = false;
    private ServletContext _servletContext;
    public static final String DOFILTER_CALLED = "org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled";
    public static final String EXTENSIONS_FILTER_INITIALIZED = "org.apache.myfaces.tomahawk.EXTENSIONS_FILTER_INITIALIZED";

    public void init(FilterConfig filterConfig) {
        String param = filterConfig.getInitParameter("uploadMaxFileSize");
        this._uploadMaxFileSize = this.resolveSize(param, this._uploadMaxFileSize);
        param = filterConfig.getInitParameter("uploadMaxSize");
        this._uploadMaxSize = param != null ? this.resolveSize(param, this._uploadMaxSize) : this.resolveSize(param, this._uploadMaxFileSize);
        param = filterConfig.getInitParameter("uploadThresholdSize");
        this._uploadThresholdSize = this.resolveSize(param, this._uploadThresholdSize);
        this._uploadRepositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        this._cacheFileSizeErrors = ExtensionsFilter.getBooleanValue(filterConfig.getInitParameter("cacheFileSizeErrors"), false);
        this._servletContext = filterConfig.getServletContext();
        filterConfig.getServletContext().setAttribute(EXTENSIONS_FILTER_INITIALIZED, (Object)true);
    }

    private long resolveSize(String param, long defaultValue) {
        long numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            long factor = 1L;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000L;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000L;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024L;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Long.parseLong(number) * factor;
        }
        return numberParam;
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    private static boolean getBooleanValue(String initParameter, boolean defaultVal) {
        if (initParameter == null || initParameter.trim().length() == 0) {
            return defaultVal;
        }
        return initParameter.equalsIgnoreCase("on") || initParameter.equals("1") || initParameter.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AddResource addResource;
        if (request.getAttribute(DOFILTER_CALLED) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(DOFILTER_CALLED, (Object)"true");
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        try {
            addResource = AddResourceFactory.getInstance(httpRequest, this._servletContext);
            if (addResource.isResourceUri(this._servletContext, httpRequest)) {
                addResource.serveResource(this._servletContext, httpRequest, httpResponse);
                return;
            }
        }
        catch (Throwable th) {
            this.log.error((Object)"Exception wile retrieving addResource", th);
            throw new ServletException(th);
        }
        Object extendedRequest = httpRequest;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
            extendedRequest = new MultipartRequestWrapper(httpRequest, this._uploadMaxFileSize, this._uploadThresholdSize, this._uploadRepositoryPath, this._uploadMaxSize, this._cacheFileSizeErrors);
        }
        try {
            if (addResource instanceof AddResource2) {
                ((AddResource2)addResource).responseStarted(this._servletContext, extendedRequest);
            } else {
                addResource.responseStarted();
            }
            if (addResource.requiresBuffer()) {
                ExtensionsResponseWrapper extendedResponse = new ExtensionsResponseWrapper((HttpServletResponse)response);
                chain.doFilter((ServletRequest)extendedRequest, (ServletResponse)extendedResponse);
                extendedResponse.finishResponse();
                HttpServletResponse servletResponse = (HttpServletResponse)response;
                if (extendedResponse.getContentType() != null && this.isValidContentType(extendedResponse.getContentType())) {
                    addResource.parseResponse((HttpServletRequest)extendedRequest, extendedResponse.toString(), servletResponse);
                    addResource.writeMyFacesJavascriptBeforeBodyEnd((HttpServletRequest)extendedRequest, servletResponse);
                    if (!addResource.hasHeaderBeginInfos()) {
                        addResource.writeResponse((HttpServletRequest)extendedRequest, servletResponse);
                        return;
                    }
                    addResource.writeWithFullHeader((HttpServletRequest)extendedRequest, servletResponse);
                    addResource.writeResponse((HttpServletRequest)extendedRequest, servletResponse);
                } else {
                    byte[] responseArray = extendedResponse.getBytes();
                    if (responseArray.length > 0) {
                        servletResponse.getOutputStream().write(responseArray);
                    }
                }
            } else {
                chain.doFilter((ServletRequest)extendedRequest, response);
            }
        }
        finally {
            addResource.responseFinished();
        }
    }

    public boolean isValidContentType(String contentType) {
        return contentType.startsWith("text/html") || contentType.startsWith("text/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/xml");
    }

    public void destroy() {
    }
}

