/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="run-platform", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class RunPlatformAppMojo
extends AbstractMojo {
    @Parameter(required=true, property="netbeans.branding.token")
    protected String brandingToken;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/userdir", property="netbeans.userdir")
    protected File netbeansUserdir;
    @Parameter(property="netbeans.run.params")
    protected String additionalArguments;
    @Parameter(property="netbeans.run.params.debug")
    protected String debugAdditionalArguments;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File exec;
        if (!"nbm-application".equals(this.project.getPackaging())) {
            throw new MojoFailureException("The nbm:run-platform goal shall be used within a NetBeans Application project only ('nbm-application' packaging)");
        }
        this.netbeansUserdir.mkdirs();
        File appbasedir = new File(this.outputDirectory, this.brandingToken);
        if (!appbasedir.exists()) {
            throw new MojoExecutionException("The directory that shall contain built application, doesn't exist (" + appbasedir.getAbsolutePath() + ")\n Please invoke 'mvn install' on the project first");
        }
        boolean windows = Os.isFamily((String)"windows");
        Commandline cmdLine = new Commandline();
        if (windows) {
            exec = new File(appbasedir, "bin" + this.brandingToken + "_w.exe");
            if (!exec.exists()) {
                File exec64;
                exec = new File(appbasedir, "bin\\" + this.brandingToken + ".exe");
                String jdkHome = System.getenv("JAVA_HOME");
                if (jdkHome != null && !new File(jdkHome, "jre\\bin\\JavaAccessBridge-32.dll").exists() && !new File(jdkHome, "\\bin\\javaaccessbridge-32.dll").exists() && (exec64 = new File(appbasedir, "bin\\" + this.brandingToken + "64.exe")).isFile()) {
                    exec = exec64;
                }
                cmdLine.addArguments(new String[]{"--console", "suppress"});
            }
        } else {
            exec = new File(appbasedir, "bin/" + this.brandingToken);
        }
        cmdLine.setExecutable(exec.getAbsolutePath());
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--userdir");
            args.add(this.netbeansUserdir.getAbsolutePath());
            args.add("-J-Dnetbeans.logger.console=true");
            args.add("-J-ea");
            args.add("--branding");
            args.add(this.brandingToken);
            if (System.getenv("JAVA_HOME") != null) {
                args.add("--jdkhome");
                args.add(System.getenv("JAVA_HOME"));
            }
            cmdLine.addArguments(args.toArray(new String[0]));
            cmdLine.addArguments(CommandLineUtils.translateCommandline((String)this.additionalArguments));
            cmdLine.addArguments(CommandLineUtils.translateCommandline((String)this.getDebugAdditionalArguments()));
            this.getLog().info((CharSequence)("Executing: " + cmdLine));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    RunPlatformAppMojo.this.getLog().info((CharSequence)line);
                }
            };
            CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed executing NetBeans", e);
        }
    }

    private String getDebugAdditionalArguments() {
        if ("true".equals(this.debugAdditionalArguments)) {
            return "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
        }
        return this.debugAdditionalArguments;
    }
}

