/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class EqualsIgnoreCaseEvaluator
extends BooleanEvaluator {
    private final Evaluator<?> subject;
    private final Evaluator<?> compareTo;

    public EqualsIgnoreCaseEvaluator(Evaluator<?> subject, Evaluator<?> compareTo) {
        this.subject = subject;
        this.compareTo = compareTo;
    }

    @Override
    public QueryResult<Boolean> evaluate(Map<String, String> attributes) {
        Object a = this.subject.evaluate(attributes).getValue();
        if (a == null) {
            return new BooleanQueryResult(false);
        }
        Object b = this.compareTo.evaluate(attributes).getValue();
        if (b == null) {
            return new BooleanQueryResult(false);
        }
        if (a instanceof String && b instanceof String) {
            return new BooleanQueryResult(((String)a).equalsIgnoreCase((String)b));
        }
        return new BooleanQueryResult(a.equals(b));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

