/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class FormatEvaluator
extends StringEvaluator {
    private final DateEvaluator subject;
    private final Evaluator<String> format;
    private final Evaluator<String> timeZone;

    public FormatEvaluator(DateEvaluator subject, Evaluator<String> format, Evaluator<String> timeZone) {
        this.subject = subject;
        this.format = format;
        this.timeZone = timeZone;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        QueryResult<String> tzResult;
        String tz;
        Date subjectValue = (Date)this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        QueryResult<String> formatResult = this.format.evaluate(attributes);
        String format = formatResult.getValue();
        if (format == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
        if (this.timeZone != null && (tz = (tzResult = this.timeZone.evaluate(attributes)).getValue()) != null && TimeZone.getTimeZone(tz) != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(tz));
        }
        return new StringQueryResult(sdf.format(subjectValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

