/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public class JsonPathEvaluator
extends StringEvaluator {
    private static final StringQueryResult EMPTY_RESULT = new StringQueryResult("");
    private static final Configuration STRICT_PROVIDER_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider()).build();
    private static final JsonProvider JSON_PROVIDER = STRICT_PROVIDER_CONFIGURATION.jsonProvider();
    private final Evaluator<String> subject;
    private final Evaluator<String> jsonPathExp;
    private final JsonPath precompiledJsonPathExp;

    public JsonPathEvaluator(Evaluator<String> subject, Evaluator<String> jsonPathExp) {
        this.subject = subject;
        this.jsonPathExp = jsonPathExp;
        this.precompiledJsonPathExp = jsonPathExp instanceof StringLiteralEvaluator ? JsonPathEvaluator.compileJsonPathExpression(jsonPathExp.evaluate(null).getValue()) : null;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null || subjectValue.length() == 0) {
            throw new AttributeExpressionLanguageException("Subject is empty");
        }
        DocumentContext documentContext = null;
        try {
            documentContext = JsonPathEvaluator.validateAndEstablishJsonContext(subjectValue);
        }
        catch (InvalidJsonException e) {
            throw new AttributeExpressionLanguageException("Subject contains invalid JSON: " + subjectValue, e);
        }
        JsonPath compiledJsonPath = this.precompiledJsonPathExp != null ? this.precompiledJsonPathExp : JsonPathEvaluator.compileJsonPathExpression(this.jsonPathExp.evaluate(attributes).getValue());
        Object result = null;
        try {
            result = documentContext.read(compiledJsonPath);
        }
        catch (Exception e) {
            return EMPTY_RESULT;
        }
        return new StringQueryResult(JsonPathEvaluator.getResultRepresentation(result, EMPTY_RESULT.getValue()));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }

    static DocumentContext validateAndEstablishJsonContext(String json) {
        DocumentContext ctx = JsonPath.using((Configuration)STRICT_PROVIDER_CONFIGURATION).parse(json);
        return ctx;
    }

    static boolean isJsonScalar(Object obj) {
        return !(obj instanceof Map) && !(obj instanceof List);
    }

    static String getResultRepresentation(Object jsonPathResult, String defaultValue) {
        if (JsonPathEvaluator.isJsonScalar(jsonPathResult)) {
            return Objects.toString(jsonPathResult, defaultValue);
        }
        if (jsonPathResult instanceof List && ((List)jsonPathResult).size() == 1) {
            return JsonPathEvaluator.getResultRepresentation(((List)jsonPathResult).get(0), defaultValue);
        }
        return JSON_PROVIDER.toJson(jsonPathResult);
    }

    static JsonPath compileJsonPathExpression(String exp) {
        try {
            return JsonPath.compile((String)exp, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageException("Invalid JSON Path expression: " + exp, e);
        }
    }
}

