/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class UrlEncodeEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;

    public UrlEncodeEvaluator(Evaluator<String> subject) {
        this.subject = subject;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        try {
            return new StringQueryResult(URLEncoder.encode(subjectValue, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

