/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.CategoryContainer;
import org.apache.openaz.pepapi.MapperRegistry;
import org.apache.openaz.pepapi.ObjectMapper;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepException;
import org.apache.openaz.pepapi.PepRequest;
import org.apache.openaz.pepapi.PepRequestAttributes;

public class CategoryContainerMapper
implements ObjectMapper {
    private static final Log logger = LogFactory.getLog(CategoryContainerMapper.class);
    private Class<?> mappedClass;
    private MapperRegistry mapperRegistry;
    private PepConfig pepConfig;

    public CategoryContainerMapper(Class<?> mappedClass) {
        this.mappedClass = mappedClass;
    }

    @Override
    public Class<?> getMappedClass() {
        return this.mappedClass;
    }

    @Override
    public void map(Object o, PepRequest pepRequest) {
        CategoryContainer a = (CategoryContainer)o;
        PepRequestAttributes pepRequestAttributes = pepRequest.getPepRequestAttributes(a.getCategoryIdentifier());
        Map<String, Object[]> aMap = a.getAttributeMap();
        if (aMap != null) {
            for (Map.Entry<String, Object[]> e : aMap.entrySet()) {
                String attributeId = this.resolveAttributeId(e.getKey());
                Object[] values = e.getValue();
                if (values != null && values.length > 0) {
                    this.map(pepRequestAttributes, attributeId, values);
                    continue;
                }
                logger.error((Object)("No value assigned for attribute : " + attributeId));
                throw new IllegalArgumentException("No or null value for attribute : " + attributeId);
            }
        }
    }

    @Override
    public void setMapperRegistry(MapperRegistry mapperRegistry) {
        this.mapperRegistry = mapperRegistry;
    }

    @Override
    public void setPepConfig(PepConfig pepConfig) {
        this.pepConfig = pepConfig;
    }

    protected String resolveAttributeId(String attributeId) {
        return attributeId;
    }

    private final void map(PepRequestAttributes pepRequestAttributes, String key, Object ... values) {
        Object value = values[0];
        if (value instanceof String) {
            pepRequestAttributes.addAttribute(key, (String[])values);
        } else if (value instanceof Long) {
            pepRequestAttributes.addAttribute(key, (Long[])values);
        } else if (value instanceof Integer) {
            pepRequestAttributes.addAttribute(key, (Integer[])values);
        } else if (value instanceof Double) {
            pepRequestAttributes.addAttribute(key, (Double[])values);
        } else if (value instanceof Boolean) {
            pepRequestAttributes.addAttribute(key, (Boolean[])values);
        } else if (value instanceof URI) {
            pepRequestAttributes.addAttribute(key, (URI[])values);
        } else if (value instanceof Date) {
            pepRequestAttributes.addAttribute(key, (Date[])values);
        } else {
            logger.error((Object)("Type: " + value.getClass().getName() + " cannot be mapped for attribute: " + key));
            throw new PepException("Can't map an object of class: " + value.getClass().getName());
        }
    }

    protected PepConfig getPepConfig() {
        return this.pepConfig;
    }

    protected MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }
}

