/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PepUtils {
    private static final Log logger = LogFactory.getLog(PepUtils.class);

    public static Class<?> loadClass(String className) {
        Class<?> clazz;
        ClassLoader currentClassLoader = PepUtils.class.getClassLoader();
        try {
            clazz = currentClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = contextClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalArgumentException(e);
            }
        }
        return clazz;
    }

    public static <T> T instantiateClass(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Properties loadProperties(String propertyFile) {
        Properties properties = new Properties();
        File file = new File(propertyFile);
        InputStream in = null;
        if (file.exists() && file.canRead()) {
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Error while accessing file: " + propertyFile));
                throw new IllegalArgumentException(e);
            }
        } else {
            ClassLoader classLoader;
            HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
            classLoaders.add(PepUtils.class.getClassLoader());
            classLoaders.add(Thread.currentThread().getContextClassLoader());
            Iterator i$ = classLoaders.iterator();
            while (i$.hasNext() && (in = (classLoader = (ClassLoader)i$.next()).getResourceAsStream(propertyFile)) == null) {
            }
            if (in == null) {
                logger.error((Object)("Invalid classpath or file location: " + propertyFile));
                throw new IllegalArgumentException("Invalid classpath or file location: " + propertyFile);
            }
        }
        try {
            properties.load(in);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Error closing stream", (Throwable)e);
                }
            }
        }
        return properties;
    }
}

