/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.openaz.pepapi.PepRequestAttributes;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdMutableRequestAttributes;

final class StdPepRequestAttributes
implements PepRequestAttributes {
    private final String id;
    private final Identifier categoryIdentifier;
    private String issuer;
    private StdMutableRequestAttributes wrappedRequestAttributes;
    private Map<Identifier, StdMutableAttribute> attributeMapById;

    StdPepRequestAttributes(String id, Identifier categoryIdentifier) {
        this.id = id;
        this.categoryIdentifier = categoryIdentifier;
        this.attributeMapById = new HashMap<Identifier, StdMutableAttribute>();
        this.wrappedRequestAttributes = new StdMutableRequestAttributes();
        this.wrappedRequestAttributes.setCategory(categoryIdentifier);
        this.wrappedRequestAttributes.setXmlId(id);
    }

    @Override
    public Identifier getCategory() {
        return this.categoryIdentifier;
    }

    @Override
    public void addAttribute(String name, Date ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_DATE);
    }

    @Override
    public void addAttribute(String name, String ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_STRING);
    }

    @Override
    public void addAttribute(String name, Integer ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_INTEGER);
    }

    @Override
    public void addAttribute(String name, Boolean ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_BOOLEAN);
    }

    @Override
    public void addAttribute(String name, Long ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_INTEGER);
    }

    @Override
    public void addAttribute(String name, Double ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_DOUBLE);
    }

    @Override
    public void addAttribute(String name, URI ... values) {
        this.addAttribute(name, values, XACML3.ID_DATATYPE_ANYURI);
    }

    private <T> void addAttribute(String name, T[] values, Identifier dataTypeId) {
        if (values == null) {
            throw new IllegalArgumentException("Null attribute value provided for attribute: " + name);
        }
        IdentifierImpl attributeId = new IdentifierImpl(name);
        StdMutableAttribute mutableAttribute = this.attributeMapById.get(attributeId);
        if (mutableAttribute == null) {
            mutableAttribute = new StdMutableAttribute();
            mutableAttribute.setAttributeId((Identifier)new IdentifierImpl(name));
            mutableAttribute.setCategory(this.categoryIdentifier);
            mutableAttribute.setIncludeInResults(false);
            mutableAttribute.setIssuer(this.issuer == null ? "" : this.issuer);
            this.attributeMapById.put((Identifier)attributeId, mutableAttribute);
            this.wrappedRequestAttributes.add((Attribute)mutableAttribute);
        }
        for (T value : values) {
            if (value == null) continue;
            mutableAttribute.addValue((AttributeValue)new StdAttributeValue(dataTypeId, value));
        }
    }

    @Override
    public RequestAttributes getWrappedRequestAttributes() {
        return this.wrappedRequestAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
}

