/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.PDPException;
import org.apache.openaz.xacml.api.pdp.ScopeResolver;
import org.apache.openaz.xacml.api.trace.TraceEngine;
import org.apache.openaz.xacml.api.trace.TraceEngineFactory;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.api.trace.Traceable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationContextFactory;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicyFinderResult;
import org.apache.openaz.xacml.std.StdIndividualDecisionRequestGenerator;
import org.apache.openaz.xacml.std.StdMutableResponse;
import org.apache.openaz.xacml.std.StdMutableResult;
import org.apache.openaz.xacml.std.StdResult;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.trace.StdTraceEvent;
import org.apache.openaz.xacml.util.FactoryException;

public class OpenAZPDPEngine
implements PDPEngine,
Traceable {
    private static final Status STATUS_ADVICE_NA = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Advice not allowed in combined decision");
    private static final Status STATUS_OBLIGATIONS_NA = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Obligations not allowed in combined decision");
    private static final Status STATUS_COMBINE_FAILED = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Individual decisions do not match");
    private static final Result RESULT_ECTX_NULL = new StdMutableResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Null EvaluationContext"));
    private static final Set<URI> PROFILES = new HashSet<URI>();
    private EvaluationContextFactory evaluationContextFactory;
    private Decision defaultDecision = Decision.INDETERMINATE;
    private ScopeResolver scopeResolver;
    private TraceEngine traceEngine;
    private Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TraceEngine getTraceEngine() {
        if (this.traceEngine == null) {
            OpenAZPDPEngine openAZPDPEngine = this;
            synchronized (openAZPDPEngine) {
                if (this.traceEngine == null) {
                    try {
                        this.traceEngine = TraceEngineFactory.newInstance().getTraceEngine();
                    }
                    catch (FactoryException ex) {
                        this.logger.error((Object)("FactoryException creating TraceEngine instance: " + ex.toString()), (Throwable)ex);
                        throw new IllegalStateException("FactoryException creating TraceEngine instance", ex);
                    }
                }
            }
        }
        return this.traceEngine;
    }

    public OpenAZPDPEngine(EvaluationContextFactory evaluationContextFactoryIn, ScopeResolver scopeResolverIn) {
        this.evaluationContextFactory = evaluationContextFactoryIn;
        this.scopeResolver = scopeResolverIn;
    }

    public OpenAZPDPEngine(EvaluationContextFactory evaluationContextFactoryIn, Decision defaultDecisionIn, ScopeResolver scopeResolverIn) {
        this(evaluationContextFactoryIn, scopeResolverIn);
        this.defaultDecision = defaultDecisionIn;
    }

    protected Result processRequest(EvaluationContext evaluationContext) {
        try {
            Collection listRequestAttributesIncludeInResult;
            EvaluationResult result;
            PolicyFinderResult<PolicyDef> policyFinderResult = evaluationContext.getRootPolicyDef();
            if (policyFinderResult.getStatus() != null && !policyFinderResult.getStatus().isOk()) {
                return new StdMutableResult(policyFinderResult.getStatus());
            }
            PolicyDef policyDefRoot = policyFinderResult.getPolicyDef();
            if (policyDefRoot == null) {
                switch (this.defaultDecision) {
                    case DENY: 
                    case NOTAPPLICABLE: 
                    case PERMIT: {
                        return new StdMutableResult(this.defaultDecision, (Status)new StdStatus(StdStatusCode.STATUS_CODE_OK, "No applicable policy"));
                    }
                    case INDETERMINATE: 
                    case INDETERMINATE_DENY: 
                    case INDETERMINATE_DENYPERMIT: 
                    case INDETERMINATE_PERMIT: {
                        return new StdMutableResult(this.defaultDecision, (Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "No applicable policy"));
                    }
                }
            }
            if ((result = policyDefRoot.evaluate(evaluationContext)).getStatus().isOk() && (listRequestAttributesIncludeInResult = evaluationContext.getRequest().getRequestAttributesIncludedInResult()) != null && listRequestAttributesIncludeInResult.size() > 0) {
                StdMutableResult stdMutableResult = new StdMutableResult((Result)result);
                stdMutableResult.addAttributeCategories(listRequestAttributesIncludeInResult);
                result = new StdResult((Result)stdMutableResult);
            }
            return result;
        }
        catch (EvaluationException ex) {
            return new StdMutableResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage()));
        }
    }

    public Response decide(Request pepRequest) throws PDPException {
        Status statusRequest;
        TraceEngine traceEngineThis = this.getTraceEngine();
        if (traceEngineThis.isTracing()) {
            traceEngineThis.trace((TraceEvent)new StdTraceEvent("Input Request", (Traceable)this, (Object)pepRequest));
        }
        if ((statusRequest = pepRequest.getStatus()) != null && !statusRequest.isOk()) {
            return new StdMutableResponse(statusRequest);
        }
        StdIndividualDecisionRequestGenerator stdIndividualDecisionRequestGenerator = new StdIndividualDecisionRequestGenerator(this.scopeResolver, pepRequest);
        boolean bCombineResults = pepRequest.getCombinedDecision();
        StdMutableResult stdResultCombined = null;
        StdMutableResponse stdResponse = new StdMutableResponse();
        Iterator iterRequestsIndividualDecision = stdIndividualDecisionRequestGenerator.getIndividualDecisionRequests();
        if (iterRequestsIndividualDecision == null || !iterRequestsIndividualDecision.hasNext()) {
            return new StdMutableResponse((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "No individual decision requests"));
        }
        while (iterRequestsIndividualDecision.hasNext()) {
            EvaluationContext evaluationContext;
            Request requestIndividualDecision = (Request)iterRequestsIndividualDecision.next();
            if (traceEngineThis.isTracing()) {
                traceEngineThis.trace((TraceEvent)new StdTraceEvent("Individual Request", (Traceable)this, (Object)requestIndividualDecision));
            }
            Object resultIndividualDecision = null;
            resultIndividualDecision = requestIndividualDecision.getStatus() != null && !requestIndividualDecision.getStatus().isOk() ? new StdMutableResult(requestIndividualDecision.getStatus()) : ((evaluationContext = this.evaluationContextFactory.getEvaluationContext(requestIndividualDecision)) == null ? RESULT_ECTX_NULL : this.processRequest(evaluationContext));
            assert (resultIndividualDecision != null);
            if (traceEngineThis.isTracing()) {
                traceEngineThis.trace((TraceEvent)new StdTraceEvent("Individual Result", (Traceable)this, resultIndividualDecision));
            }
            if (bCombineResults) {
                Decision decision = resultIndividualDecision.getDecision();
                Status status = resultIndividualDecision.getStatus();
                if (resultIndividualDecision.getAssociatedAdvice().size() > 0) {
                    decision = Decision.INDETERMINATE;
                    status = STATUS_ADVICE_NA;
                } else if (resultIndividualDecision.getObligations().size() > 0) {
                    decision = Decision.INDETERMINATE;
                    status = STATUS_OBLIGATIONS_NA;
                }
                if (stdResultCombined == null) {
                    stdResultCombined = new StdMutableResult(decision, status);
                } else if (stdResultCombined.getDecision() != resultIndividualDecision.getDecision()) {
                    stdResultCombined.setDecision(Decision.INDETERMINATE);
                    stdResultCombined.setStatus(STATUS_COMBINE_FAILED);
                }
                stdResultCombined.addPolicyIdentifiers(resultIndividualDecision.getPolicyIdentifiers());
                stdResultCombined.addPolicySetIdentifiers(resultIndividualDecision.getPolicySetIdentifiers());
                stdResultCombined.addAttributeCategories(resultIndividualDecision.getAttributes());
                if (!traceEngineThis.isTracing()) continue;
                traceEngineThis.trace((TraceEvent)new StdTraceEvent("Combined result", (Traceable)this, (Object)stdResultCombined));
                continue;
            }
            stdResponse.add(resultIndividualDecision);
        }
        if (bCombineResults) {
            stdResponse.add(stdResultCombined);
        }
        return stdResponse;
    }

    public Collection<URI> getProfiles() {
        return Collections.unmodifiableCollection(PROFILES);
    }

    public boolean hasProfile(URI uriProfile) {
        return PROFILES.contains(uriProfile);
    }

    public String getTraceId() {
        return this.getClass().getCanonicalName();
    }

    public Traceable getCause() {
        return null;
    }

    static {
        PROFILES.add(XACML3.ID_PROFILE_MULTIPLE_COMBINED_DECISION.getUri());
        PROFILES.add(XACML3.ID_PROFILE_MULTIPLE_REFERENCE.getUri());
        PROFILES.add(XACML3.ID_PROFILE_MULTIPLE_REPEATED_ATTRIBUTE_CATEGORIES.getUri());
        PROFILES.add(XACML3.ID_PROFILE_MULTIPLE_SCOPE.getUri());
        PROFILES.add(XACML3.ID_PROFILE_MULTIPLE_XPATH_EXPRESSION.getUri());
    }
}

