/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentExpression;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentResult;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.std.StdMutableAdvice;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.StringUtils;

public class AdviceExpression
extends PolicyComponent {
    private List<AttributeAssignmentExpression> listAttributeAssignmentExpressions = new ArrayList<AttributeAssignmentExpression>();
    private Identifier adviceId;
    private RuleEffect appliesTo;

    protected List<AttributeAssignmentExpression> getAttributeAssignmentExpressionList() {
        return this.listAttributeAssignmentExpressions;
    }

    protected void clearAttributeAssignmentExpressionList() {
        this.getAttributeAssignmentExpressionList().clear();
    }

    public AdviceExpression(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public AdviceExpression(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public AdviceExpression() {
    }

    public AdviceExpression(Identifier adviceIdIn, RuleEffect ruleEffectIn, Collection<AttributeAssignmentExpression> attributeAssignmentExpressions) {
        this.adviceId = adviceIdIn;
        this.appliesTo = ruleEffectIn;
        if (attributeAssignmentExpressions != null) {
            this.listAttributeAssignmentExpressions.addAll(attributeAssignmentExpressions);
        }
    }

    public Identifier getAdviceId() {
        return this.adviceId;
    }

    public void setAdviceId(Identifier identifier) {
        this.adviceId = identifier;
    }

    public RuleEffect getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(RuleEffect ruleEffect) {
        this.appliesTo = ruleEffect;
    }

    public Iterator<AttributeAssignmentExpression> getAttributeAssignmentExpressions() {
        return this.getAttributeAssignmentExpressionList().iterator();
    }

    public void setAttributeAssignmentExpressions(Collection<AttributeAssignmentExpression> attributeAssignmentExpressions) {
        this.clearAttributeAssignmentExpressionList();
    }

    public void addAttributeAssignmentExpression(AttributeAssignmentExpression attributeAssignmentExpression) {
        this.getAttributeAssignmentExpressionList().add(attributeAssignmentExpression);
    }

    public void addAttributeAssignmentExpressions(Collection<AttributeAssignmentExpression> attributeAssignmentExpressions) {
        this.getAttributeAssignmentExpressionList().addAll(attributeAssignmentExpressions);
    }

    public Advice evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return null;
        }
        ArrayList<AttributeAssignment> attributeAssignments = new ArrayList<AttributeAssignment>();
        Iterator<AttributeAssignmentExpression> iterAttributeAssignmentExpressions = this.getAttributeAssignmentExpressions();
        if (iterAttributeAssignmentExpressions != null) {
            while (iterAttributeAssignmentExpressions.hasNext()) {
                AttributeAssignmentResult attributeAssignmentResult = iterAttributeAssignmentExpressions.next().evaluate(evaluationContext, policyDefaults);
                if (!attributeAssignmentResult.isOk() || attributeAssignmentResult.getNumAttributeAssignments() <= 0) continue;
                Iterator<AttributeAssignment> iterAttributeAssignments = attributeAssignmentResult.getAttributeAssignments();
                while (iterAttributeAssignments.hasNext()) {
                    attributeAssignments.add(iterAttributeAssignments.next());
                }
            }
        }
        return new StdMutableAdvice(this.getAdviceId(), attributeAssignments);
    }

    public static List<Advice> evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults, Decision decision, Collection<AdviceExpression> listAdviceExpressions) throws EvaluationException {
        ArrayList<Advice> listAdvices = new ArrayList<Advice>();
        for (AdviceExpression adviceExpression : listAdviceExpressions) {
            Advice advice;
            adviceExpression.validateComponent();
            if (!adviceExpression.isOk()) {
                throw new EvaluationException(adviceExpression.getStatusMessage());
            }
            if (decision != null && !adviceExpression.getAppliesTo().getDecision().equals((Object)decision) || (advice = adviceExpression.evaluate(evaluationContext, policyDefaults)) == null) continue;
            listAdvices.add(advice);
        }
        return listAdvices;
    }

    @Override
    protected boolean validateComponent() {
        if (this.getAdviceId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AdviceId");
            return false;
        }
        if (this.getAppliesTo() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AppliesTo");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getAdviceId();
        if (objectToDump != null) {
            stringBuilder.append(",adviceId=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getAppliesTo()) != null) {
            stringBuilder.append(",appliesTo=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = StringUtils.toString(this.getAttributeAssignmentExpressions())) != null) {
            stringBuilder.append(",attributeAssignmentExpressions=");
            stringBuilder.append((String)objectToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

