/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameter;

public class TargetedCombinerParameterMap<T, U> {
    List<TargetedCombinerParameter<T, U>> targetedCombinerParameters = null;
    Map<T, U> mapTargetIdToTarget = new HashMap<T, U>();
    Map<U, List<CombinerParameter>> mapTargetToCombinerParameters = null;

    private void ensureTargetedCombinerParameters() {
        if (this.targetedCombinerParameters == null) {
            this.targetedCombinerParameters = new ArrayList<TargetedCombinerParameter<T, U>>();
        }
    }

    protected U resolve(TargetedCombinerParameter<T, U> targetedCombinerParameter) {
        U result = targetedCombinerParameter.getTarget();
        if (result != null) {
            return result;
        }
        result = this.mapTargetIdToTarget.get(targetedCombinerParameter.getTargetId());
        if (result != null) {
            targetedCombinerParameter.setTarget(result);
            return result;
        }
        return null;
    }

    protected void ensureMap() throws IllegalStateException {
        if (this.mapTargetToCombinerParameters == null && this.targetedCombinerParameters != null && this.targetedCombinerParameters.size() > 0) {
            this.mapTargetToCombinerParameters = new HashMap<U, List<CombinerParameter>>();
            for (TargetedCombinerParameter<T, U> targetedCombinerParameter : this.targetedCombinerParameters) {
                U target = this.resolve(targetedCombinerParameter);
                if (target == null) {
                    throw new IllegalStateException("Unresolved TargetCombinerParameter \"" + targetedCombinerParameter.toString() + "\"");
                }
                List<CombinerParameter> listCombinerParameters = this.mapTargetToCombinerParameters.get(target);
                if (listCombinerParameters == null) {
                    listCombinerParameters = new ArrayList<CombinerParameter>();
                    this.mapTargetToCombinerParameters.put(target, listCombinerParameters);
                }
                listCombinerParameters.add(targetedCombinerParameter);
            }
        }
    }

    public void addTarget(T targetId, U target) {
        this.mapTargetIdToTarget.put(targetId, target);
    }

    public void addCombinerParameter(TargetedCombinerParameter<T, U> targetdCombinerParameter) {
        this.ensureTargetedCombinerParameters();
        this.targetedCombinerParameters.add(targetdCombinerParameter);
        this.mapTargetToCombinerParameters = null;
    }

    public void addCombinerParameters(Collection<TargetedCombinerParameter<T, U>> listTargetedCombinerParameters) {
        this.ensureTargetedCombinerParameters();
        this.targetedCombinerParameters.addAll(listTargetedCombinerParameters);
        this.mapTargetToCombinerParameters = null;
    }

    public void setCombinerParameters(Collection<TargetedCombinerParameter<T, U>> listTargetedCombinerParameters) {
        this.targetedCombinerParameters = null;
        if (listTargetedCombinerParameters != null) {
            this.addCombinerParameters(this.targetedCombinerParameters);
        }
    }

    public List<CombinerParameter> getCombinerParameters(U target) throws IllegalStateException {
        this.ensureMap();
        return this.mapTargetToCombinerParameters == null ? null : this.mapTargetToCombinerParameters.get(target);
    }

    public Iterator<TargetedCombinerParameter<T, U>> getTargetedCombinerParameters() {
        return this.targetedCombinerParameters == null ? null : this.targetedCombinerParameters.iterator();
    }
}

