/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.AllOf;
import org.apache.openaz.xacml.pdp.policy.dom.DOMMatch;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAllOf
extends AllOf {
    private static final Log logger = LogFactory.getLog(DOMAllOf.class);

    protected DOMAllOf() {
    }

    public static AllOf newInstance(Node nodeAllOf) throws DOMStructureException {
        DOMAllOf domAllOf;
        block6: {
            Element elementAllOf = DOMUtil.getElement((Node)nodeAllOf);
            boolean bLenient = DOMProperties.isLenient();
            domAllOf = new DOMAllOf();
            try {
                int numChildren;
                NodeList children = elementAllOf.getChildNodes();
                boolean sawMatch = false;
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "Match".equals(child.getLocalName())) {
                            domAllOf.addMatch(DOMMatch.newInstance(child));
                            sawMatch = true;
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeAllOf);
                    }
                }
                if (!sawMatch && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)nodeAllOf, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Match");
                }
            }
            catch (DOMStructureException ex) {
                domAllOf.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block6;
                throw ex;
            }
        }
        return domAllOf;
    }

    public static boolean repair(Node nodeAllOf) throws DOMStructureException {
        int numChildren;
        Element elementAllOf = DOMUtil.getElement((Node)nodeAllOf);
        boolean result = false;
        NodeList children = elementAllOf.getChildNodes();
        boolean sawMatch = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "Match".equals(child.getLocalName())) {
                    result = DOMMatch.repair(child) || result;
                    sawMatch = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementAllOf.removeChild(child);
                result = true;
            }
        }
        if (!sawMatch) {
            throw DOMUtil.newMissingElementException((Node)nodeAllOf, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Match");
        }
        return result;
    }
}

