/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPolicyDefaults
extends PolicyDefaults {
    private static final Log logger = LogFactory.getLog(DOMPolicyDefaults.class);

    protected DOMPolicyDefaults(URI xpathVersionIn, PolicyDefaults policyDefaultsParentIn) {
        super(xpathVersionIn, policyDefaultsParentIn);
    }

    public static PolicyDefaults newInstance(Node nodePolicyDefaults, PolicyDefaults policyDefaultsParent) throws DOMStructureException {
        int numChildren;
        Element elementPolicyDefaults = DOMUtil.getElement((Node)nodePolicyDefaults);
        boolean bLenient = DOMProperties.isLenient();
        URI uriXPathVersion = null;
        NodeList children = elementPolicyDefaults.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "XPathVersion".equals(child.getLocalName())) {
                    uriXPathVersion = DOMUtil.getURIContent((Node)child);
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicyDefaults);
            }
        }
        return new DOMPolicyDefaults(uriXPathVersion, policyDefaultsParent);
    }

    public static boolean repair(Node nodePolicyDefaults) throws DOMStructureException {
        int numChildren;
        Element elementPolicyDefaults = DOMUtil.getElement((Node)nodePolicyDefaults);
        boolean result = false;
        NodeList children = elementPolicyDefaults.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "XPathVersion".equals(child.getLocalName())) {
                    try {
                        DOMUtil.getURIContent((Node)child);
                    }
                    catch (DOMStructureException ex) {
                        logger.warn((Object)("Setting invalid XPathVersion attribute " + child.getTextContent() + " to " + "http://www.w3.org/TR/2007/REC-xpath20-20070123"));
                        child.setTextContent("http://www.w3.org/TR/2007/REC-xpath20-20070123");
                        result = true;
                    }
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementPolicyDefaults.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

