/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameter;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPolicySetCombinerParameter
extends TargetedCombinerParameter<Identifier, PolicySetChild> {
    public static final Log logger = LogFactory.getLog(DOMPolicySetCombinerParameter.class);

    protected DOMPolicySetCombinerParameter() {
    }

    public static TargetedCombinerParameter<Identifier, PolicySetChild> newInstance(Node nodeCombinerParameter) throws DOMStructureException {
        DOMPolicySetCombinerParameter domPolicySetCombinerParameter;
        block7: {
            Element elementPolicySetCombinerParameter = DOMUtil.getElement((Node)nodeCombinerParameter);
            boolean bLenient = DOMProperties.isLenient();
            domPolicySetCombinerParameter = new DOMPolicySetCombinerParameter();
            try {
                int numChildren;
                NodeList children = elementPolicySetCombinerParameter.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                            if (domPolicySetCombinerParameter.getAttributeValue() != null && !bLenient) {
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeCombinerParameter);
                            }
                            domPolicySetCombinerParameter.setAttributeValue(DOMAttributeValue.newInstance((Node)child, null));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeCombinerParameter);
                    }
                }
                if (domPolicySetCombinerParameter.getAttributeValue() == null && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)elementPolicySetCombinerParameter, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
                }
                domPolicySetCombinerParameter.setName(DOMUtil.getStringAttribute((Node)elementPolicySetCombinerParameter, (String)"ParameterName", (!bLenient ? 1 : 0) != 0));
                domPolicySetCombinerParameter.setTargetId(DOMUtil.getIdentifierAttribute((Node)elementPolicySetCombinerParameter, (String)"PolicySetIdRef", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                domPolicySetCombinerParameter.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block7;
                throw ex;
            }
        }
        return domPolicySetCombinerParameter;
    }

    public static boolean repair(Node nodeCombinerParameter) throws DOMStructureException {
        int numChildren;
        Element elementPolicySetCombinerParameter = DOMUtil.getElement((Node)nodeCombinerParameter);
        boolean result = false;
        NodeList children = elementPolicySetCombinerParameter.getChildNodes();
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                    if (sawAttributeValue) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicySetCombinerParameter.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawAttributeValue = true;
                    result = DOMAttributeValue.repair((Node)child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementPolicySetCombinerParameter.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributeValue) {
            throw DOMUtil.newMissingElementException((Node)elementPolicySetCombinerParameter, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
        }
        result = DOMUtil.repairStringAttribute((Element)elementPolicySetCombinerParameter, (String)"ParameterName", (String)"parameter", (Log)logger) || result;
        result = DOMUtil.repairIdentifierAttribute((Element)elementPolicySetCombinerParameter, (String)"PolicySetIdRef", (Log)logger) || result;
        return result;
    }
}

