/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.Target;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAnyOf;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTarget
extends Target {
    private static final Log logger = LogFactory.getLog(DOMTarget.class);

    protected DOMTarget() {
    }

    public static Target newInstance(Node nodeTarget) throws DOMStructureException {
        DOMTarget domTarget;
        block5: {
            Element elementTarget = DOMUtil.getElement((Node)nodeTarget);
            boolean bLenient = DOMProperties.isLenient();
            domTarget = new DOMTarget();
            try {
                int numChildren;
                NodeList children = elementTarget.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AnyOf".equals(child.getLocalName())) {
                            domTarget.addAnyOf(DOMAnyOf.newInstance(child));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeTarget);
                    }
                }
            }
            catch (DOMStructureException ex) {
                domTarget.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block5;
                throw ex;
            }
        }
        return domTarget;
    }

    public static boolean repair(Node nodeTarget) throws DOMStructureException {
        int numChildren;
        Element elementTarget = DOMUtil.getElement((Node)nodeTarget);
        boolean result = false;
        NodeList children = elementTarget.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AnyOf".equals(child.getLocalName())) {
                    result = DOMAnyOf.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementTarget.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

