/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.VariableDefinition;
import org.apache.openaz.xacml.pdp.policy.dom.DOMExpression;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMVariableDefinition
extends VariableDefinition {
    private static final Log logger = LogFactory.getLog(DOMVariableDefinition.class);

    protected DOMVariableDefinition() {
    }

    public static VariableDefinition newInstance(Node nodeVariableDefinition, Policy policy) throws DOMStructureException {
        DOMVariableDefinition domVariableDefinition;
        block8: {
            Element elementVariableDefinition = DOMUtil.getElement((Node)nodeVariableDefinition);
            boolean bLenient = DOMProperties.isLenient();
            domVariableDefinition = new DOMVariableDefinition();
            try {
                Element elementExpression = DOMUtil.getFirstChildElement((Node)elementVariableDefinition);
                if (elementExpression != null) {
                    if (DOMExpression.isExpression(elementExpression)) {
                        domVariableDefinition.setExpression(DOMExpression.newInstance(elementExpression, policy));
                    } else if (!bLenient) {
                        throw DOMUtil.newUnexpectedElementException((Node)elementExpression, (Node)elementVariableDefinition);
                    }
                } else if (!bLenient) {
                    throw DOMUtil.newMissingElementException((Node)elementVariableDefinition, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Expression");
                }
                domVariableDefinition.setId(DOMUtil.getStringAttribute((Node)elementVariableDefinition, (String)"VariableId", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                domVariableDefinition.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block8;
                throw ex;
            }
        }
        return domVariableDefinition;
    }

    public static boolean repair(Node nodeVariableDefinition) throws DOMStructureException {
        Element elementVariableDefinition = DOMUtil.getElement((Node)nodeVariableDefinition);
        boolean result = false;
        Element elementExpression = DOMUtil.getFirstChildElement((Node)elementVariableDefinition);
        if (elementExpression != null) {
            if (DOMExpression.isExpression(elementExpression)) {
                result = result || DOMExpression.repair(elementExpression);
            } else {
                logger.warn((Object)("Unexpected element " + elementExpression.getNodeName()));
                elementVariableDefinition.removeChild(elementExpression);
                result = true;
            }
        } else {
            throw DOMUtil.newMissingElementException((Node)elementVariableDefinition, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Expression");
        }
        result = result || DOMUtil.repairStringAttribute((Element)elementVariableDefinition, (String)"VariableId", (String)"variable", (Log)logger);
        return result;
    }
}

