/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeRetrievalBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.NodeNamespaceContext;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.util.FactoryException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeSelector
extends AttributeRetrievalBase {
    private Identifier contextSelectorId;
    private String path;
    private DataType<?> dataType;

    protected DataType<?> getDataType() {
        Identifier dataTypeIdThis = this.getDataTypeId();
        if (dataTypeIdThis == null) {
            return null;
        }
        DataTypeFactory dataTypeFactory = null;
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
            if (dataTypeFactory == null) {
                return null;
            }
        }
        catch (FactoryException ex) {
            return null;
        }
        this.dataType = dataTypeFactory.getDataType(dataTypeIdThis);
        return this.dataType;
    }

    public AttributeSelector(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public AttributeSelector(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public AttributeSelector() {
    }

    public Identifier getContextSelectorId() {
        return this.contextSelectorId;
    }

    public void setContextSelectorId(Identifier identifier) {
        this.contextSelectorId = identifier;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String pathIn) {
        this.path = pathIn;
    }

    @Override
    protected boolean validateComponent() {
        if (!super.validateComponent()) {
            return false;
        }
        if (this.getPath() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Path");
            return false;
        }
        return true;
    }

    protected List<XPathExpression> getContextSelectorValues(RequestAttributes requestAttributes) {
        Identifier thisContextSelectorId = this.getContextSelectorId();
        if (thisContextSelectorId == null) {
            return null;
        }
        ArrayList<Object> listXPathExpressions = null;
        Iterator iterAttributes = requestAttributes.getAttributes(thisContextSelectorId);
        if (iterAttributes != null) {
            while (iterAttributes.hasNext()) {
                Attribute attribute = (Attribute)iterAttributes.next();
                Iterator iterXPathExpressions = attribute.findValues((DataType)DataTypes.DT_XPATHEXPRESSION);
                if (iterXPathExpressions == null || !iterXPathExpressions.hasNext()) continue;
                if (listXPathExpressions == null) {
                    listXPathExpressions = new ArrayList<Object>();
                }
                listXPathExpressions.add(((AttributeValue)iterXPathExpressions.next()).getValue());
            }
        }
        return listXPathExpressions;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return ExpressionResult.newError((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        DataType<?> thisDataType = this.getDataType();
        Request request = evaluationContext.getRequest();
        assert (request != null);
        Iterator iterRequestAttributes = request.getRequestAttributes(this.getCategory());
        if (iterRequestAttributes == null || !iterRequestAttributes.hasNext()) {
            return this.getEmptyResult("No Attributes with Category " + this.getCategory().toString(), null);
        }
        Bag bagAttributeValues = new Bag();
        StdStatus statusFirstError = null;
        while (iterRequestAttributes.hasNext()) {
            RequestAttributes requestAttributes = (RequestAttributes)iterRequestAttributes.next();
            Node nodeContentRoot = requestAttributes.getContentRoot();
            if (nodeContentRoot == null) continue;
            ArrayList<Node> listNodesToQuery = new ArrayList<Node>();
            List<XPathExpression> listXPathExpressions = this.getContextSelectorValues(requestAttributes);
            if (listXPathExpressions == null) {
                listNodesToQuery.add(nodeContentRoot);
            } else {
                for (XPathExpression xpathExpression : listXPathExpressions) {
                    Node nodeContent = requestAttributes.getContentNodeByXpathExpression(xpathExpression);
                    if (nodeContent == null) continue;
                    listNodesToQuery.add(nodeContent);
                }
            }
            if (listNodesToQuery.size() <= 0) continue;
            for (Node nodeToQuery : listNodesToQuery) {
                NodeList nodeList;
                block18: {
                    nodeList = null;
                    try {
                        XPath xPath = XPathFactory.newInstance().newXPath();
                        xPath.setNamespaceContext((NamespaceContext)new NodeNamespaceContext(nodeToQuery.getOwnerDocument()));
                        XPathExpression xPathExpression = xPath.compile(this.getPath());
                        Node nodeToQueryDocumentRoot = null;
                        try {
                            nodeToQueryDocumentRoot = DOMUtil.getDirectDocumentChild((Node)nodeToQuery);
                        }
                        catch (DOMStructureException ex) {
                            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Exception processing context node: " + ex.getMessage()));
                        }
                        nodeList = (NodeList)xPathExpression.evaluate(nodeToQueryDocumentRoot, XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException ex) {
                        if (statusFirstError != null) break block18;
                        statusFirstError = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "XPathExpressionException: " + ex.getMessage());
                    }
                }
                if (nodeList == null || nodeList.getLength() <= 0) continue;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    AttributeValue attributeValueNode;
                    block19: {
                        attributeValueNode = null;
                        try {
                            attributeValueNode = thisDataType.createAttributeValue((Object)nodeList.item(i));
                        }
                        catch (DataTypeException ex) {
                            if (statusFirstError != null) break block19;
                            statusFirstError = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage());
                        }
                    }
                    if (attributeValueNode != null) {
                        bagAttributeValues.add(attributeValueNode);
                        continue;
                    }
                    if (statusFirstError != null) continue;
                    statusFirstError = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Unable to convert node to " + this.getDataTypeId().toString());
                }
            }
        }
        if (bagAttributeValues.size() == 0) {
            if (statusFirstError == null) {
                return this.getEmptyResult("No Content found", null);
            }
            return ExpressionResult.newError(statusFirstError);
        }
        return ExpressionResult.newBag(bagAttributeValues);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getContextSelectorId();
        if (objectToDump != null) {
            stringBuilder.append(",contextSelectorId=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getPath()) != null) {
            stringBuilder.append(",path=");
            stringBuilder.append((String)objectToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

