/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.combiners;

import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.pdp.std.combiners.CombiningAlgorithmBase;

public class LegacyDenyOverridesRule
extends CombiningAlgorithmBase<Rule> {
    public LegacyDenyOverridesRule(Identifier identifierIn) {
        super(identifierIn);
    }

    @Override
    public EvaluationResult combine(EvaluationContext evaluationContext, List<CombiningElement<Rule>> elements, List<CombinerParameter> combinerParameters) throws EvaluationException {
        boolean atLeastOnePermit = false;
        boolean potentialDeny = false;
        EvaluationResult combinedResult = new EvaluationResult(Decision.PERMIT);
        EvaluationResult evaluationResultIndeterminate = null;
        block6: for (CombiningElement<Rule> combiningElement : elements) {
            EvaluationResult evaluationResultElement = combiningElement.evaluate(evaluationContext);
            assert (evaluationResultElement != null);
            switch (evaluationResultElement.getDecision()) {
                case DENY: {
                    return evaluationResultElement;
                }
                case INDETERMINATE: 
                case INDETERMINATE_DENYPERMIT: 
                case INDETERMINATE_DENY: 
                case INDETERMINATE_PERMIT: {
                    if (evaluationResultIndeterminate == null) {
                        evaluationResultIndeterminate = evaluationResultElement;
                    } else {
                        evaluationResultIndeterminate.merge(evaluationResultElement);
                    }
                    if (combiningElement.getEvaluatable().getRuleEffect() == RuleEffect.DENY) {
                        potentialDeny = true;
                    }
                }
                case NOTAPPLICABLE: {
                    continue block6;
                }
                case PERMIT: {
                    atLeastOnePermit = true;
                    combinedResult.merge(evaluationResultElement);
                    continue block6;
                }
            }
            throw new EvaluationException("Illegal Decision: \"" + evaluationResultElement.getDecision().toString());
        }
        if (potentialDeny) {
            return evaluationResultIndeterminate;
        }
        if (atLeastOnePermit) {
            return combinedResult;
        }
        if (evaluationResultIndeterminate != null) {
            return evaluationResultIndeterminate;
        }
        return new EvaluationResult(Decision.NOTAPPLICABLE);
    }
}

