/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.combiners;

import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.pdp.std.combiners.CombiningAlgorithmBase;

public class LegacyPermitOverridesRule
extends CombiningAlgorithmBase<Rule> {
    public LegacyPermitOverridesRule(Identifier identifierIn) {
        super(identifierIn);
    }

    @Override
    public EvaluationResult combine(EvaluationContext evaluationContext, List<CombiningElement<Rule>> elements, List<CombinerParameter> combinerParameters) throws EvaluationException {
        boolean atLeastOneDeny = false;
        boolean potentialPermit = false;
        EvaluationResult evaluationResultCombined = new EvaluationResult(Decision.DENY);
        EvaluationResult evaluationResultIndeterminate = null;
        block6: for (CombiningElement<Rule> combiningElement : elements) {
            EvaluationResult evaluationResultElement = combiningElement.evaluate(evaluationContext);
            assert (evaluationResultElement != null);
            switch (evaluationResultElement.getDecision()) {
                case DENY: {
                    atLeastOneDeny = true;
                    evaluationResultCombined.merge(evaluationResultElement);
                    continue block6;
                }
                case INDETERMINATE: 
                case INDETERMINATE_DENYPERMIT: 
                case INDETERMINATE_DENY: 
                case INDETERMINATE_PERMIT: {
                    if (evaluationResultIndeterminate == null) {
                        evaluationResultIndeterminate = evaluationResultElement;
                    } else {
                        evaluationResultIndeterminate.merge(evaluationResultElement);
                    }
                    if (combiningElement.getEvaluatable().getRuleEffect() != RuleEffect.PERMIT) continue block6;
                    potentialPermit = true;
                    continue block6;
                }
                case NOTAPPLICABLE: {
                    continue block6;
                }
                case PERMIT: {
                    return evaluationResultElement;
                }
            }
            throw new EvaluationException("Illegal Decision: \"" + evaluationResultElement.getDecision().toString());
        }
        if (potentialPermit) {
            return evaluationResultIndeterminate;
        }
        if (atLeastOneDeny) {
            return evaluationResultCombined;
        }
        if (evaluationResultIndeterminate != null) {
            return evaluationResultIndeterminate;
        }
        return new EvaluationResult(Decision.NOTAPPLICABLE);
    }
}

