/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class FunctionDefinitionBagOneAndOnly<I>
extends FunctionDefinitionBase<I, I> {
    public FunctionDefinitionBagOneAndOnly(Identifier idIn, DataType<I> dataTypeArgsIn) {
        super(idIn, dataTypeArgsIn, dataTypeArgsIn, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 1) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 1 argument, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument argument = arguments.get(0);
        ConvertedArgument convertedArgument = new ConvertedArgument(argument, null, true);
        if (!convertedArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument.getStatus()));
        }
        Bag bag = convertedArgument.getBag();
        if (bag.size() != 1) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 1 but Bag has " + bag.size() + " elements"));
        }
        AttributeValue<?> attributeValueOneAndOnly = bag.getAttributeValues().next();
        assert (attributeValueOneAndOnly != null);
        if (!this.getDataTypeId().equals((Object)attributeValueOneAndOnly.getDataTypeId())) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Element in bag of wrong type. Expected " + this.getShortDataTypeId(this.getDataTypeId()) + " got " + this.getShortDataTypeId(attributeValueOneAndOnly.getDataTypeId())));
        }
        return ExpressionResult.newSingle(attributeValueOneAndOnly);
    }
}

